/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l5IH
 */

package
{
    import alternativ7.engine3d.materials.TextureMaterial;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import alternativ7.engine3d.containers.ConflictContainer
    import alternativ7.engine3d.core.View
    import alternativ7.engine3d.core.Camera3D
    import alternativ7.engine3d.controllers.SimpleObjectController
    import alternativ7.engine3d.primitives.Box
    import alternativ7.engine3d.materials.FillMaterial
    import alternativ7.engine3d.loaders.MaterialLoader;
    
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.system.ApplicationDomain
    import flash.system.Security;
    import flash.system.LoaderContext;
    /**
     * TokyoTeraco11 その6
     * テクスチャーを外部から読み込んでみよう！
     *
     * @author narutohyper
     */
    [SWF(backgroundColor="#000000", frameRate="60")]
    public class Main extends Sprite
    {
        
        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.BEST;
            
            //ルートオブジェクト（Root Object）
            var container:ConflictContainer = new ConflictContainer();

            //ビューを作る
            var view:View = new View(stage.stageWidth, stage.stageHeight);
            addChild(view);

            //カメラを作る
            var camera:Camera3D = new Camera3D();

            //カメラとビューを関連付ける
            camera.view = view;

            //カメラを撮影する3D空間に配置する
            container.addChild(camera);

            //カメラの位置を調整
            camera.x = 0;
            camera.y = -500;
            camera.z = 0;

            //カメラをコントローラ
            var cameraController:SimpleObjectController = new SimpleObjectController(stage, camera, 10);
            cameraController.mouseSensitivity = 0
            cameraController.unbindAll()
            cameraController.lookAtXYZ(0, 0, 0)
            
            //クロスドメイン対策（Wonderfl用）
            var context :LoaderContext = new LoaderContext();
            Security.loadPolicyFile("http://marubayashi.net/crossdomain.xml");
            context.applicationDomain = ApplicationDomain.currentDomain;               
                        
            
            //テクスチャーマテリアルを作成
            var matArry:Vector.<TextureMaterial> = new Vector.<TextureMaterial>(6)
            var path:String = 'http://marubayashi.net/archive/sample/teraco/';
            

            for (var i:int = 0; i < 6; i++)
            {
                matArry[i] = new TextureMaterial()
                matArry[i].diffuseMapURL = path + 'cube' + (i + 1) + '.png';
            }
            
            //Textureに使用する画像を読み込む
            var materialLoader:MaterialLoader = new MaterialLoader()
            materialLoader.load(matArry);
            

            
            //オブジェクトを作成して3D空間（コンテナ）に追加
            var box:Box = new Box(100, 100, 100, 1, 1, 1, false,false,matArry[0],matArry[5],matArry[1],matArry[4],matArry[2],matArry[3])
            container.addChild(box)


            //オブジェクトコントローラを追加
            var objectController:SimpleObjectController = new SimpleObjectController(stage, box, 10);
            objectController.mouseSensitivity = 1
            objectController.unbindAll()

            addEventListener(Event.ENTER_FRAME, onEnterFrame)

            var RADIAN:Number = Math.PI/180

            function onEnterFrame(e:Event):void
            {
                //box.rotationY += RADIAN
                //カメラコントローラの操作をコントロールオブジェクトに反映
                cameraController.update();
                
                //オブジェクトコントローラの操作をコントロールオブジェクトに反映
                objectController.update();
                
                //レンダリング
                camera.render();
            }
                    
            
        }

        
    }
    
}