/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l5G9
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    public class FlashTest extends Sprite {
        private var _p:Particle;
        
        public function FlashTest() {
            init();            
        }
        
        private function init():void {
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onClick(e:MouseEvent):void {
            var n:uint = Math.random() * 100;
            trace(n);
            for(var i:uint=0; i < n; i++) {
                _p = new Particle(Math.random()*stage.stageWidth, stage.stageHeight + 30, Math.random() * 2, Math.random() * 3, Math.random() * 0.5);
                addChild(_p);
            }
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
class Particle extends Sprite {
    private var _b:Ball;
    private var _vx:Number;
    private var _vy:Number;
    private var _ay:Number;
    private var _x:Number;
    private var _y:Number;
    
    private var _rad:Number;
    
    public function Particle(x:Number, y:Number, vx:Number, vy:Number, ay:Number) {
        _x = x;
        _y = y;
        _vx = vx;
        _vy = vy;
        _ay = ay;
        _rad = -180 + Math.random()*360;
        init();
    }
    
    private function init():void {
        _b = new Ball(Math.random()*30, Math.random()*0xffffff);
        addChild(_b);
        _b.x = _x;
        _b.y = _y;
        _b.alpha = Math.random() * 0.8;
        _b.addEventListener(Event.ENTER_FRAME, onLoop);
    }
    
    private function onLoop(e:Event):void {
        _b.x += Math.sin(_rad) * _vx;
        _b.y -= _vy;
        _vy += _ay;
        _rad += 0.1;
        
        if(_b.x > stage.stageWidth || _b.x < 0 || _b.y < 0) {
            _b.removeEventListener(Event.ENTER_FRAME, onLoop);
            removeChild(_b);
            parent.removeChild(this);
            _b = null;
        }
    }
}

import flash.display.Sprite;
class Ball extends Sprite {
    private var _col:uint;
    private var _r:Number;
    private var _sp:Sprite;
    
    public function Ball(r:Number = 10, col:uint = 0x0) {
        _r = r;
        _col = col;
        init();
    }
    
    private function init():void {
        _sp = new Sprite();
        _sp.graphics.beginFill(_col);
        _sp.graphics.drawCircle(0, 0, _r);
        _sp.graphics.endFill();
        addChild(_sp);        
    }
    
    public function colorTrans(col:uint):void {
        _col = col;
        reDraw();
    }
    
    private function reDraw():void {
        _sp.graphics.clear();
        _sp.graphics.beginFill(_col);
        _sp.graphics.drawCircle(0, 0, _r);
        _sp.graphics.endFill();
    }
}

