/**
 * Copyright nan05aur ( http://wonderfl.net/user/nan05aur )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l544
 */

// forked from nan05aur's forked from: test_4
// forked from nan05aur's forked from: test_3
// forked from nan05aur's forked from: test_2
// forked from nan05aur's forked from: test
// forked from nan05aur's forked from: forked from: 速度の変化率が異なる三つの正方形
// forked from nan05aur's forked from: 速度の変化率が異なる三つの正方形
// forked from shmdmoto's 速度の変化率が異なる三つの正方形
package 
{
    import frocessing.display.F5MovieClip2D;
    [SWF(width = 465, height = 465, frameRate = 60)]
    /**
     * 速度の変化率が異なる三つの正方形．
     * @author shmdmoto
     */
    public class DynamicsSample1 extends F5MovieClip2D
    {
        public var num:int = 250;
        public var posX:Number;
        public var posY:Number;
        public var posXA:Array;
        public var posYA:Array;
        public var pi:Number = 3.14;
        public var theta:Number = 270;
        public var v:Number = 1;
        public var vX:Number = 0;
        public var vY:Number = 0;
        public var vXA:Array;
        public var vYA:Array;
        public function setup() : void
        {
            posX = stage.stageWidth / 2;
            posY = stage.stageHeight / 2;
            posXA = new Array(num);
            posYA = new Array(num);
            vXA = new Array(num);
            vYA = new Array(num);
            for( var i:int = 0 ; i < num ; i++ )
            {
                posXA[i] = new Number();
                posYA[i] = new Number();
                posXA[i] = stage.stageWidth / 2;
                posYA[i] = stage.stageHeight / 2;
            }
            initDir();
            initCircle();
            Wonderfl.disable_capture();
            stroke(0);
        }
        public function draw() : void
        {
            rectMode(CENTER);
            for( var i:int = 0 ; i < num ; i++ )
            {
                fill(0,200,200);
                //strokeWeight(3);
                //stroke(255,255,0);
                //noStroke();
                //noFill()
                rect( posXA[i], posYA[i], 15,15);
                posXA[i] += vXA[i];
                posYA[i] += vYA[i];
            }
            fill(0,200,255);
            ellipse(stage.stageWidth/2,stage.stageHeight/2,10,10);
        }
        public function initDir():void
        {
            vX = cos( pi / 180 * theta ) * v;
            vY = sin( pi / 180 * theta ) * v;
        }
        public function initCircle():void
        {
            var odd:Boolean;
            var radStep:Number = pi * 2 / num;
            var rad:Number = odd ? radStep / 2 : 0;
            for( var i:int = 0 ; i < num ; i++, rad += radStep )
            {
                //v = random(0.5,9);
                vXA[i] = new Number();
                vYA[i] = new Number();
                vXA[i] = cos( rad ) * v;
                vYA[i] = sin( rad ) * v;
            }
        }
    }
}

// 以下は，動きを記述するためのクラスですので，編集しないでください．
import flash.utils.getTimer;
import frocessing.math.PerlinNoise;
/**
 * Interpolate:指定した時間で，開始値から終値までの過渡的を
 *             記述するクラス
 */
class Interpolate
{
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 3;
    private var duration  :Number;
    private var begin     :Number;
    private var end       :Number;
    private var pow       :Number;
    private var tOffset   :Number;
    private var tElapsed  :Number;
    private var prevVal   :Number;
    private var tRestart  :Number;
    public  var status    :int = NOINIT;
    public function Interpolate( t:Number, s:Number, f:Number,
                                 p:Number = 1) {
        begin = prevVal = s;
        end = f;
        duration = t;
        pow = p;
    }
    public function val() :Number {
        var t :Number;
        if( status == NOINIT){
            tOffset = getTimer()/1000;
            prevVal = begin;
            status = RUNNING;
        } else if( status == RUNNING ) {
            t = getTimer()/1000;
            tElapsed = t -tOffset;
            if( tElapsed < duration ) {
                prevVal = begin + ( end - begin )*Math.pow(tElapsed/duration,pow);
            } else {
                prevVal = end;
                status = STOPPED;
            }
        } else if( status == WAITING){
            t = getTimer()/1000;
            if( t >= tRestart) {
                status = RUNNING;
                tOffset = t - tElapsed;        
            }
        }
        return prevVal;
    }
    public function pause() :void
    {
        status = STOPPED;        
    }
    public function cont() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000-tElapsed;        
    }
    public function start() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000;                
    }
    public function wait( waitTime :Number ) :void
    {
        status = WAITING;
        tRestart = getTimer() + waitTime;
    }
    
    public function isRunning() :Boolean
    {
        if( status == RUNNING ) {
            return true;
        } else {
            return false;
        }
    }
    public function isStopped() :Boolean
    {
        if( status == STOPPED ) {
            return true;
        } else {
            return false;
        }
    }
    public function isEnd() :Boolean
    {
        if( prevVal >= end) {
            return true;
        } else {
            return false;
        }
    }
}
/**
 * LFO:指定した時間での周期的変動を記述するクラス
 */
class LFO {
    public static const SIN    :int = 1;
    public static const COS    :int = 2;
    public static const SAW    :int = 3;
    public static const TRI    :int = 4;
    public static const SQR    :int = 5;
    public static const ABSSIN :int = 6;
    public static const NOISE  :int = 7;
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var period    :Number;
    private var amplitude :Number;
    private var phase     :Number;
    private var offset    :Number;
    private var type      :int = SIN;
    private var isStart   :Boolean;
    private var t_offset  :Number;
    private var status    :int = NOINIT;
    
    public function LFO( prd :Number, amp :Number,
                         of :Number = 0, ph :Number = 0)
    {
        period    = prd;
        amplitude = amp;
        offset    = of;
        phase     = ph;
    }
    public function setPeak( min :Number, max :Number) :void
    {
        offset = (min + max) / 2;
        if( min < max ) {
            amplitude    = (max - min) / 2;
        } else {
            amplitude    = (min - max) / 2;
        }        
    }
    public function setType( t :int ) :void
    {
        type = t;
    }
    public function val( mul :Number=1.0 ) :Number {
        if(status == NOINIT) {
            status = RUNNING;
            t_offset = getTimer() / 1000.0;
            return val();
        } else if(status == RUNNING　) {
            var t :Number = getTimer() / 1000.0 - t_offset;
            var temp :Number;
            switch(type) {
                case SIN :
                    return  offset + mul * amplitude * 
                            Math.sin(2.0 * Math.PI *( t/period + phase) );
                case COS :
                    return  offset + mul * amplitude *
                            Math.cos(2.0 * Math.PI *( t/period + phase) );
                case SAW :
                    temp = t / period + 0.5 + phase - 
                            Math.floor( t / period + 0.5 + phase ) - 0.5;
                    return  offset + 2.0 * mul * amplitude * temp;
                case TRI :
                    temp = t / period + phase - 
                            Math.floor (t / period + phase );
                    if( 0.0 <= temp && temp < 0.25 ) {
                        return offset + mul * amplitude * 4.0 * temp;
                    } else if( temp < 0.75 ) {
                        return offset + mul * amplitude * (  2.0 - 4.0 * temp);
                    } else {
                        return offset + mul * amplitude * ( -4.0 + 4.0 * temp);
                    }
                case SQR :
                    temp = t/period + phase - 
                            Math.floor( t / period + phase);
                    if( temp < 0.5 ){
                        return offset + mul * amplitude;
                    } else {
                        return offset - mul * amplitude;
                    }
                case ABSSIN :
                    return  offset + 
                        Math.abs(mul * amplitude * Math.sin(2.0*Math.PI *( t/period + phase)));
                case NOISE :
                    var p :PerlinNoise = new PerlinNoise(); 
                    return offset -mul * amplitude + 2.0 * mul * amplitude * p.noise(t/period+phase,1);
                default :
                    return 0.0;
            }
        } else {
            return 0.0;
        }        
    }
}    