/**
 * Copyright dimitris.1972g ( http://wonderfl.net/user/dimitris.1972g )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l4g6
 */

// forked from koba789's forked from: RTMFPビデオチャット（RTMFP Video Chat Example）
// forked from mousepancyo's RTMFPビデオチャット（RTMFP Video Chat Example）
package  {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.NetStatusEvent;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.net.NetGroup;
    import flash.net.GroupSpecifier;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.media.Microphone;
    import flash.media.SoundCodec;
    import com.bit101.components.*;
        
    [SWF(width = "465", height = "465", backgroundColor = "0", frameRate = "30")]
    public class Main extends Sprite{        
        private const GROUP_NAME:String = "myGroup/videoChat";
        private var _nc:NetConnection;
        private var _ns:NetStream;
        private var _rns:NetStream;
        private var _ng:NetGroup;
        private var _gs:GroupSpecifier;
        private var _cam:Camera;
        private var _mic:Microphone;
        private var _video:Video;
        private var _streamName:String = "MultiCastStream";
        private var _sendBtn:PushButton;
        private var _rcvBtn:PushButton;
        private var _msgTxt:TextArea;
        private var _inputTxt:InputText;
        private var _startScreen:StartScreen;

        public function Main() {
            _video = new Video(320, 240);
            _video.x = (stage.stageWidth *.5 - 160) | 0;
            _video.y = stage.stageHeight - 300;
            addChild(new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0))); 
            var sp1:Shape = new Shape();
            sp1.graphics.beginFill(0xFFFFFF);
            sp1.graphics.drawRect(0, 0, 465, 150);
            var sp2:Shape = new Shape();
            sp2.graphics.lineStyle(3, 0x666666, 1);
            sp2.graphics.drawRect(_video.x, _video.y, 320, 240);
            addChild(sp1);
            addChild(sp2);
            addChild(_video);
            //
            Style.embedFonts = false;
            Style.fontName = "_typewriter";
            Style.fontSize = 12;
            _sendBtn = new PushButton(this, 21, 115, "Broad Cast", broadCast);
            _sendBtn = new PushButton(this, 359, 431, "Send Message", sendMsg);
            _msgTxt = new TextArea(this, 141, 15);
            _msgTxt.width = 315;
            _msgTxt.height = 120;
            _inputTxt = new InputText(this, 10, 431);
            _inputTxt.width = 340;
            _inputTxt.height = 20;
            var label:Label = new Label(this, 10, 413, "Send Message");
            //
            _startScreen = new StartScreen();
            _startScreen.bt.addEventListener(MouseEvent.CLICK, doConnect);
            addChild(_startScreen);
        }
        
        private function doConnect(e:MouseEvent):void {
            _startScreen.bt.removeEventListener(MouseEvent.CLICK, doConnect);
            removeChild(_startScreen);
            //
            _nc = new NetConnection();
            _nc.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
            _nc.connect("rtmfp://p2p.rtmfp.net/d50e06cd29e27d62167444cd-b7f858253166/");
        }

        private function netStatusHandler(e:NetStatusEvent):void {
            trace(e.target, e.info.code);
            _msgTxt.text = e.info.code + "\n" + _msgTxt.text;
            switch(e.info.code){
                case "NetConnection.Connect.Success":
                    addNetGroup()
                    break;
                case "NetGroup.Connect.Success":
                    _msgTxt.text = "OK1" + "\n\n" +_msgTxt.text;
                    watchStream();
                    break;
                case "NetStream.Connect.Success":
                    break;
                case "NetStream.Publish.Start":
                    break;
                case "NetGroup.Posting.Notify":
                    _msgTxt.text = e.info.message.text + "\n\n" +_msgTxt.text;
                    break;
            }
        }
        
        // Camera&Mic Initialized
        private function setUpCamera():void{
            _cam = Camera.getCamera();
            _cam.setMode(320, 240, 15);
            _cam.setQuality(0, 90);
            _mic = Microphone.getMicrophone();
            _mic.codec = SoundCodec.SPEEX;
            _mic.setLoopBack();
            var video:Video = new Video(120, 90);
            video.x = 10;
            video.y = 15;
            video.attachCamera(_cam);
            addChild(video);
        }
        
        // NetGroup
        private function addNetGroup():void{
            _gs = new GroupSpecifier(GROUP_NAME);
            _gs.postingEnabled = true;
            _gs.multicastEnabled = true;
            _ng = new NetGroup(_nc, _gs.groupspecWithAuthorizations());
            _ng.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
        }
        
        
        // NetStream
        private function broadCast(e:MouseEvent):void {
            _sendBtn.removeEventListener(MouseEvent.CLICK, watchStream);
            _sendBtn.enabled = false;
            setUpCamera();
            //
            _ns = new NetStream(_nc, _gs.groupspecWithAuthorizations());
            _ns.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
            _ns.attachCamera(_cam);
            _ns.attachAudio(_mic);
            _ns.publish(_streamName);
        }
        private function sendMsg(e:MouseEvent):void{
            var message:Object = new Object();
            message.text = _inputTxt.text;
            message.sender = _ng.convertPeerIDToGroupAddress(_nc.nearID); 
            _ng.post(message);
        }
        private function watchStream():void{
            _rns = new NetStream(_nc, _gs.groupspecWithAuthorizations());
            _rns.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
            _video.attachNetStream(_rns);
            _rns.play(_streamName);
        }
    }
}

import flash.display.Sprite;
import com.bit101.components.*;
class StartScreen extends Sprite{
    public var bt:PushButton;
    public function StartScreen(){
        graphics.beginFill(0, .7);
        graphics.drawRect(0, 0, 465, 465);
        bt = new PushButton(this, 180, 230, "Start Connect", null);
        var label:Label = new Label(this, 95, 260, "To begin, please click the connections");
    }
}