/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l4Re
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import frocessing.color.*;
    
    public class FlashTest extends Sprite {
        private const VERTEX:int = 8;
        private const LINE:int = 15;
        private const THICK:Number = 1;
        private const ALPHA:Number = 1;
        private const SPEED:Number = 1;
        
        private const W:int = stage.stageWidth / 2;
        private const H:int = stage.stageHeight / 2;
        private const HUE:Number = 90 / LINE;
        
        private var o:Circular = new Circular(W,H,50,1,0);
        private var r:Circular = new Circular((W<H?W:H)*3/4, 0, (W<H?W:H)/5, 0.5, 0);
        private var v:Vector.<Circular> = new Vector.<Circular>(VERTEX, true);
        private var l:Vector.<Circular> = new Vector.<Circular>(LINE, true);
        private var cmd:Vector.<int> = new Vector.<int>(VERTEX + 1, true);
        private var dat:Vector.<Number> = new Vector.<Number>(VERTEX + 1 << 1, true);
        private var hsv:ColorHSV = new ColorHSV(0, 1, 1);
        private var shp:Shape = new Shape();
        private var bmd:BitmapData = new BitmapData(W * 2, H * 2, false, 0x000000);
        private var buf:BitmapData = bmd.clone();
        private var pt:BlurFilter = new BlurFilter(32, 32);
        private var ct:ColorTransform = new ColorTransform(0.9, 0.9, 0.9);
        
        public function FlashTest() {
            var i:int;
            for(i=0; i<VERTEX; i++) v[i] = new Circular(o.x,o.y,r.x,0.25,360*i/VERTEX);
            for(i=0; i<LINE; i++) l[i] = new Circular(0,0,0,0,360*i/LINE);
            cmd[0] = 1;
            for(i = 1; i <= VERTEX; i++) cmd[i] = 2;
            addChild(new Bitmap(bmd));
            addEventListener(Event.ENTER_FRAME, onEnterFrame);            
        }
        
        private function onEnterFrame(e:Event):void
        {
            var i:int, j:int;
            shp.graphics.clear();
            hsv.h = Circular.t;
            
            for(i = 0; i < LINE; i++) {
                for(j = 0; j < VERTEX; j++) {
                    l[i].ox = v[i].x;
                    l[i].oy = v[i].y;
                    l[i].r = r.x / 4;
                    l[i].w = j*j/VERTEX + SPEED;
                    
                    dat[j*2>>0] = l[i].x;
                    dat[j*2+1>>0] = l[i].y;
                }
                dat[j*2>>0] = dat[0];
                dat[j*2+1>>0] = dat[1];
                
                shp.graphics.lineStyle

            }

        }

    }
}