/**
 * Copyright devon_o ( http://wonderfl.net/user/devon_o )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l43h
 */

package
{
    /**
     * Pixelate Shader - may be handy for 8-bit post processing effect
     * 
     * Thank you so much Adobe for not including basic operations like floor, ceil, or mod in AGAL...
     * 
     * 
     * @author Devon O.
     */
    
    import com.adobe.utils.*;
    import com.bit101.components.HUISlider;
    import flash.display.*;
    import flash.display3D.*;
    import flash.display3D.textures.Texture;
    import flash.events.*;
    import flash.geom.Matrix3D;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="#000000")]
    public class Pixelate extends Sprite
    {
        private var mContext3d:Context3D;
        private var mVertBuffer:VertexBuffer3D;
        private var mIndexBuffer:IndexBuffer3D; 
        private var mProgram:Program3D;
        private var mTexture:Texture;
        private var mTextureData:BitmapData;
        
        private var mMatrix:Matrix3D = new Matrix3D();
        private var mPixelSize:Number = 1.0;
        
        public function Pixelate()
        {    
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);    
        }
        
        private function init(event:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            initStage();
            initSlider();
            loadImage();
            
            addEventListener(Event.ENTER_FRAME, onTick);
        }
        
        private function loadImage():void {
            var l:Loader = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoad);
            l.load(new URLRequest("http://assets.wonderfl.net/images/related_images/6/68/68ef/68efcb70438fb102c11265efe3fd1a737160999c"), new LoaderContext(true));
        }
        
        private function onImageLoad(event:Event = null):void
        {
            event.currentTarget.removeEventListener(Event.COMPLETE, onImageLoad);
            var l:Loader = (event.currentTarget as LoaderInfo).loader;
            mTextureData = (l.content as Bitmap).bitmapData;    
            stage.stage3Ds[0].addEventListener( Event.CONTEXT3D_CREATE, initStage3d );
            stage.stage3Ds[0].requestContext3D();
        }
        
        private function initStage():void
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
        }
        
        private function initSlider():void
        {
            var back:Shape = new Shape();
            back.graphics.beginFill(0x000000, .90);
            back.graphics.drawRect(0, 0, 190, 40);
            back.graphics.endFill();
            addChild(back);
            
            var slider:HUISlider = new HUISlider(this, 10, 10, "Pixel Size", onPixelSizeChange);
            slider.minimum = 1;
            slider.maximum = 25;
            slider.value = 1;
        }
        
        private function onPixelSizeChange(event:Event):void
        {
            var slider:HUISlider = event.currentTarget as HUISlider;
            mPixelSize = slider.value;
        }
        
        private function initStage3d(event:Event):void
        {
            mContext3d = stage.stage3Ds[0].context3D;            
            
            mContext3d.configureBackBuffer(stage.stageWidth, stage.stageHeight, 1, true);
            
            var vertices:Vector.<Number> = Vector.<Number>([
            //    x        y        z            u     v
                -1.0,     -1.0,     0,          0, 0, 
                -1.0,      1.0,     0,             0, 1,
                 1.0,      1.0,     0,             1, 1,
                 1.0,     -1.0,     0,            1, 0  ]);
            
            mVertBuffer = mContext3d.createVertexBuffer(4, 5);
            mVertBuffer.uploadFromVector(vertices, 0, 4);
            
            mIndexBuffer = mContext3d.createIndexBuffer(6);            
            mIndexBuffer.uploadFromVector (Vector.<uint>([0, 1, 2, 2, 3, 0]), 0, 6);
            
            mTexture = mContext3d.createTexture(mTextureData.width, mTextureData.height, Context3DTextureFormat.BGRA, true);
            mTexture.uploadFromBitmapData(mTextureData);
            
            // va0 holds xyz
            mContext3d.setVertexBufferAt(0, mVertBuffer, 0, Context3DVertexBufferFormat.FLOAT_3);
            
            // va1 holds uv
            mContext3d.setVertexBufferAt(1, mVertBuffer, 3, Context3DVertexBufferFormat.FLOAT_2);
            
            generateMicroProg();
            
            mContext3d.setTextureAt(0, mTexture);
            mContext3d.setProgram(mProgram);
        }
        
        private function generateMicroProg():void
        {
            var vertexShaderAssembler : AGALMiniAssembler = new AGALMiniAssembler();
            vertexShaderAssembler.assemble( Context3DProgramType.VERTEX,
                "m44 op, va0, vc0                                \n" +
                "mov v0, va1                                      "
            );
            var fragmentShaderAssembler : AGALMiniAssembler= new AGALMiniAssembler();
            fragmentShaderAssembler.assemble( Context3DProgramType.FRAGMENT,
                "div ft0, v0, fc0                                \n" +
                "frc ft1, ft0                                    \n" +
                "sub ft0, ft0, ft1                                \n" +
                "mul ft0, ft0, fc0                                \n" +
                "tex oc, ft0, fs0<2d, clamp, nearest>"
            );
            
            mProgram = mContext3d.createProgram();
            mProgram.upload( vertexShaderAssembler.agalcode, fragmentShaderAssembler.agalcode);
        }
        
        private function onTick(event:Event):void
        {
            if ( !mContext3d ) 
                return;
            
            mContext3d.clear ( 0, 0, 0, 1 );
            
            // set vertex data from blank Matrix3D
            mContext3d.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, mMatrix, true);
            
            // pixel size
            var scaleRatioX:Number = 1 / stage.stageWidth;
            var scaleRatioY:Number = 1 / stage.stageHeight;
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, Vector.<Number>( [ mPixelSize * scaleRatioX, mPixelSize * scaleRatioY, 1, 1 ]) );

            mContext3d.drawTriangles(mIndexBuffer);
            mContext3d.present();
        }
    }
}