/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l3KK
 */

/*
   階段を上るやつ。
   前、Papervision3Dで作ったやつを無理やりFP10でやった。
   zソートさえ出来ればFP10の3D機能ってめっちゃ使える。
   でもPapervision3Dのほうが軽いかなー。
*/
package
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="40")]
    public class Main extends Sprite
    {
        private var container:Sprite;
        private var cube:Sprite;
        private var objects:Array;
        private var planes:Array;
        private var xx:Number
        private var planeN:int;
        
        public function Main()
        {
            // コンテナの用意
            container=addChild(new Sprite) as Sprite;
            container.x=465 / 2;
            container.y=465 / 2;
            container.scaleX=container.scaleY=container.scaleZ=1.8;
            planeN = xx = 0;
            
            cube=container.addChild(new Sprite) as Sprite;
            objects = [];
            objects.push(cube);
            planeN++;
            
            // Cubeを作る
            planes = [];
            planes.push(createPlane(0, 90, 5, 0, 0, cube));
            planes.push(createPlane(0, -90, -5, 0, 0, cube));
            planes.push(createPlane(-90, 0, 0, -5, 0, cube));
            planes.push(createPlane(90, 0, 0, 5, 0, cube));
            planes.push(createPlane(0, 0, 0, 0, -5, cube));
            planes.push(createPlane(0, 0, 0, 0, 5, cube));
            
            // 階段を作る
            for(var i:int=-200; i < 200; i+=10)
            {
                objects.push(createPlane(90, 0, i, -i+5, 0, container));
                objects.push(createPlane(0, 90, i+5, -i, 0, container));
                planeN+=2;
            }
            
            // イベントの追加
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        // 平面を作成する関数
        private function createPlane(rotationX:Number, rotationY:Number ,x:Number, y:Number, z:Number, sp:Sprite):Sprite
        {
            var shape:Sprite = sp.addChild(new Sprite) as Sprite;
            var g:Graphics = shape.graphics;
            g.beginFill(0xFFFFFF * Math.random(), 0.6);
            g.drawRect(-5, -5, 10, 10);
            g.endFill();
            
            shape.rotationX = rotationX;
            shape.rotationY = rotationY;
            shape.x = x;
            shape.y = y;
            shape.z = z;
            
            return shape;
        }
        
        // フレームイベント用関数
        private function onFrame(e:Event):void
        {
            container.rotationY+=0.5;
            
            // ここでCubeの座標を計算
            cube.x=10 * xx;
            cube.y=-10 * ((-3 - 2 * Math.sqrt(2.0)) * (xx - 2 + Math.sqrt(2.0) - Math.floor(xx)) * (xx - 2 + Math.sqrt(2.0) - Math.floor(xx)) + 2 + Math.floor(xx));
            xx+=0.1;
            if (xx >= 18) xx=-18;
            
            // 色々ソート
            var array:Array=[];
            for(var i:int=0; i < 6; i++)
            {
                var shape:Sprite = planes[i];
                var mat:Matrix3D=shape.transform.getRelativeMatrix3D(this);
                array.push({sp:shape, z:mat.position.z});
            }
            array.sortOn("z", Array.NUMERIC | Array.DESCENDING);
            for(i=0; i < 6; i++)
            {
                shape = array[i].sp as Sprite;
                cube.setChildIndex(shape, i);
            }
            array=[];
            for(i=0; i < planeN; i++)
            {
                shape = objects[i] as Sprite;
                mat=shape.transform.getRelativeMatrix3D(this);
                array.push({sp:shape, z:mat.position.z});
            }
            array.sortOn("z", Array.NUMERIC | Array.DESCENDING);
            for(i=0; i < planeN; i++)
            {
                shape = array[i].sp as Sprite;
                container.setChildIndex(shape, i);
            }
        }
    }
}