/**
 * Copyright sr_forest ( http://wonderfl.net/user/sr_forest )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l2Ug
 */

// forked from shotaicho's RibbonDrawing
//------------------------------------------------------------
// title : RibbonDrawing
// 
// 読みこんだ画像の色をうねうねに反映させる
//------------------------------------------------------------
package 
{
    import __AS3__.vec.Vector;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.Timer; 
    
    [SWF(backgroundColor="0xffffff", frameRate="30")]
    public class BitmapDraw01 extends Sprite
    {
     
        private const IMAGE_URL:String = "http://www.chutaicho.com/image/sample.jpg"; 
        
	    private const DOTS_MAX:Number = 50; 		
	    private const SPEED_RANGE:Number = 40; 		
		
        private var _drawImage:BitmapData;
       
		private var _dotNumber:Number = 0;
		private var _dots:Vector.<Vertex>;
		private var _codeWidth:Number = 1;
		private var _startX:Number;
		private var _startY:Number;
        
        public function BitmapDraw01()
        {
			init();
        }
        private function init():void
        {
        	var req:URLRequest = new URLRequest(IMAGE_URL);
        	var loader:Loader = new Loader();
        	loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);	
        	loader.load( req, new LoaderContext(true));
        	
        }
        private function loadComplete(e:Event):void
        {
        	var sw:int = stage.stageWidth;
        	var sh:int = stage.stageHeight;
        	
        	// 読み込んだ画像をリサイズ
        	var bm:Bitmap = e.target.loader.content as Bitmap;
        	bm.width  = sw;
        	bm.height = sh;
        	
        	
        	_drawImage = new BitmapData(sw,sh, true, 0xff);
        	_drawImage.draw(bm);
        	
     
        	
        		
			_dots = new Vector.<Vertex>();
			
        	var timer:Timer = new Timer(1000/10, 0);
			timer.addEventListener(TimerEvent.TIMER, createDot);
			timer.start();
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			
			_startX = stage.stageWidth >> 1;
			_startY = stage.stageHeight >> 1;
        }
      
        
        private function createDot(e:TimerEvent):void 
        {
			var dot:Vertex = new Vertex();
			dot.x = mouseX;
			dot.y = mouseY;
			dot.color = _drawImage.getPixel(mouseX, mouseY);
                        //dot.color = Math.random()* 0xFFF;
			
			_dots.push(dot);	
				
			if (_dotNumber >= DOTS_MAX) 
			{
				var target:Vertex = _dots.shift();
				target = null;
			}	
			
			_dotNumber ++;	
		}
		private function enterFrameHandler (e:Event):void
		{		
			graphics.clear();
			var codeWidth:Number = 0;
			var l:int = _dots.length;
			for(var i:int = l-1; i > 0; i-- )
			{	
				var dot:Vertex = _dots[i];
				dot.upDate();
				
				if (i>0)
				codeWidth += 1;
				else
				codeWidth *= 0.95;

				if (dot.y > stage.stageHeight - dot.rad ) 
				{
					dot.y = stage.stageHeight - dot.rad;
					dot.speedY *= -2;
				}
				
				if( i == l-1 )
				{
					graphics.moveTo(dot.x, dot.y);
				}
				else
				{
					var dotB:Vertex = _dots[i-1];
					var mx:Number = dot.x + (dotB.x - dot.x)*.8;
					var my:Number = dot.y + (dotB.y - dot.y)*.8;
					graphics.lineStyle(codeWidth, dot.color, 0.5);
					graphics.curveTo(dot.x, dot.y, mx, my);				
				}				
			}
							
		}
    }
}
/**
* 頂点クラス
*/
   
class Vertex
{
    private const GRAVITY:Number  = 0.5; // 重力
	private const FRICTION:Number = 0.98; // 減速抵抗
    public var x:Number;
    public var y:Number;
    public var rad:Number = 2;
    public var speedX:Number;
    public var speedY:Number;
    public var index:int;
    public var gravity:Number;
    public var color:uint;
    public var randonNum:Number;
        
    public function Vertex()
    {
    	init();
    }
    private function init():void
    {
		var angle:Number = Math.random()*Math.PI*2;
        randonNum = Math.random() * 4;
		speedX = Math.cos(angle) * randonNum;
		speedY = Math.sin(angle) * randonNum;   	
    }
    public function upDate():void
    {
    	speedY += GRAVITY;
				
		speedX *= FRICTION;
		speedY *= FRICTION;
		
		x += speedX;
		y += speedY;
    }
}