/**
 * Copyright dizgid ( http://wonderfl.net/user/dizgid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l232
 */

// forked from dizgid's forked from: stage.qualityとnativeの3D描画について
// forked from dizgid's stage.qualityとnativeの3D描画について
/*
左下の黒丸クリックでstageのqualityを変更してsprite生成

赤がLOWのときにつくったsprite
青がHIGHのときにつくったsprite

3Dのspriteがstage.qualityを変更しても生成時の見えが保持されている。
StageQuality.HIGHのときにつくったものは、stage.qualityを変えてもスムーズ。
StageQuality.LOWのときにつくったものは、stage.qualityを変えてもスムーズではない。
この描画を、制御できないのか？
*/
package {
	import flash.text.TextFormat;
	import flash.text.TextField;
	import flash.events.MouseEvent;
	import flash.display.StageQuality;
    import flash.display.Sprite;
    import flash.events.Event;
    import net.hires.debug.Stats;
     [SWF(frameRate="60")]
    public class FlashTest extends Sprite {
    	
    		private var _preSp:Sprite;
    		private var _count:int;
        public function FlashTest() {
        		stage.quality = StageQuality.HIGH;
			_count = 0;
			
			var btn:Sprite = new Sprite();
			btn.graphics.beginFill(0x000000);
			btn.graphics.drawCircle(20,stage.stageHeight - 20, 10);
			btn.graphics.endFill();
			this.addChild(btn);
        		btn.addEventListener(MouseEvent.CLICK, _mouseClickHandler);
        		
        		this.addChild(new Stats());
        }
        private function _toggleQuality():void
        {
			stage.quality = (_count % 2 == 0) ? StageQuality.LOW : StageQuality.HIGH;
        }
        private function _mouseClickHandler(e:MouseEvent):void
        {
            	//_delete();
            	_toggleQuality();
            	_create();
            	_count++;
        }
        private function _create():void
        {
        	    var sp:Sprite = new Sprite();
            var size:Number = 250;
            var color:uint = (_count % 2 == 0) ? 0xff0000 : 0x0000ff;
            sp.graphics.lineStyle(4, 0x000000);
            sp.graphics.beginFill(color, 0.6);
            sp.graphics.drawRect(-size/2, -size/2, size, size);
            sp.graphics.endFill();
            
            var txt:TextField = new TextField();
            txt.defaultTextFormat = new TextFormat(null, 60);
            txt.type = "input";
            txt.text = "FLASH TEST";
            txt.width = size;
            txt.x = -size/2;
            txt.y = 0;
            sp.addChild(txt);
            
            sp.x = stage.stageWidth / 2;
            sp.y = stage.stageHeight / 2;
            sp.x += Math.random() * 60 - 35;
            sp.y += Math.random() * 60 - 35;
            sp.rotationZ = 20;//3D
            //sp.rotation = 20;//2D
            sp.addEventListener(Event.ENTER_FRAME, function():void{ sp.rotationY += 0.5; txt.rotationX += 0.25});
            
            this.addChild(sp);
            
            _preSp = sp;
        }
        private function _delete():void
        {
        		if(_preSp != null){
        			this.removeChild(_preSp);
        		}
        }
    }
}