/**
 * Copyright yabuchany ( http://wonderfl.net/user/yabuchany )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l1D1
 */

// forked from yabuchany's forked from: Flower Plotter forked from: FrocessingSample
// forked from HaraMakoto's Flower Plotter forked from: FrocessingSample
//see http://gihyo.jp/design/feature/01/frocessing/0001
package {
	import frocessing.display.*;

	import frocessing.geom.FMatrix2D;

	[SWF( width="465" , height="465" , frameRate="60" )]
	public class FrocessingSketch extends F5MovieClip2DBmp {
		private var stage_width:Number=465;
		private var stage_height:Number=465;
		private var n:int=5;
		private var t:Number=0;

		private var flowercounter:int=0;
		private var stemcounter:int=0;

		private var offsetX:Number=100;
		private var offsetX2:Number=150;
		private var offsetY:Number=-stage_height / 2 + 50;
		private var flef:int=0;

		private var startX:Number , startY:Number;
		private var goalX:Number , goalY:Number;

		private var col:Number , hh:Number , bb:Number , c2:Number;

		public function FrocessingSketch () {
			super();
		}

		public function setup ():void {
			colorMode( HSB , 255 );
			size( stage_width , stage_height );
			background( 255 );
			noFill();
		}

		public function draw ():void {
			hh=0;
			bb=random( 0 , 80 ) + random( 0 , 80 ) + random( 0 , 80 );
			c2=random( 0 , 40 );
			if ( hh < 40 ) {
				hh+=1;
			} else {
				hh=0;
			}
			//col=color( hh , 50 , bb , 5 );
			col = color(hh,c2,bb,5);
			stroke( col );
			if ( flowercounter > 1200 )
				return;

			if ( stemcounter < 5 ) {
				beginShape();
				drawStem();
				endShape();
			}

			beginShape();
			drawFlower();
			endShape();

			stemcounter++;
		}

		public function mousePressed ():void {
			offsetX=-200 + 400 * Math.random();
			offsetX2=offsetX + -40 + 20 * Math.random();
			offsetY=-stage_height / 2 + 150 * Math.random()
			stemcounter=0;
			flowercounter=0;
			//background( 0 );
			flef=random( 5 , 0 );
		}

		private function drawStem ():void {
			startX=stage_width / 2 + offsetX2;
			startY=stage_height;
			goalX=stage_width / 2 + offsetX;
			goalY=stage_height + offsetY;
			//
			curveTightness(700);
			//
//			curveVertex( startX , startY + 50 );
//			curveVertex( startX , startY );
//			curveVertex( noise( -25 * Math.random() , 0 * Math.random()) * 10 + startX , goalY + 200 );
//			curveVertex( noise( 25 * Math.random() , 0 * Math.random()) * 10 + startX , goalY + 100 );
//			curveVertex( goalX , goalY );
//			curveVertex( goalX , goalY - 50 );

			point(startX, startY + 50);
			point(startX, startY);
			point(noise(-25 * Math.random(), 0 * Math.random()) * 10 + startX, goalY + 200);
			point(noise(25 * Math.random(), 0 * Math.random()) * 10 + startX, goalY + 100);
			point(goalX, goalY);
			point(goalX, goalY - 50);
		}

		private function drawFlower ():void {
			curveVertex( stage_width / 2 + offsetX , stage_height + offsetY );
			for ( var i:int=0 ; i <= n ; i++ ) {

				var xx:Number , yy:Number;

				switch ( flef ) {
					case ( 0 ):
						xx=noise( i * 0.25 , t ) * 300 - 150;
						yy=stage_height - i * noise( i * 0.25 , t ) * stage_height / n;
						break;
					case ( 1 ):
						xx=noise( i * 0.25 , t ) * 300 - 150;
						yy=stage_height - i * noise( i * 0.75 * Math.cos( t ) , t ) * stage_height / n;
						break;
					case ( 2 ):
						xx=noise( i * 0.25 , t ) * 300 - 150;
						yy=stage_height - i * noise( i * 0.75 * Math.cos( t ) * Math.sin( t ) , t ) * stage_height / n;
						break;
					case ( 3 ):
						xx=noise( i * 0.25 , t ) * 300 - 150;
						yy=stage_height - i * noise( i * 0.01 , t * 0.1 ) * stage_height / n;
						break;
					case ( 4 ):
						xx=noise( i * 0.25 , t ) * 300 - 150;
						yy=stage_height - i * noise( i * 0.5 , t * 3 ) * stage_height / n;
						break;
				}

				translate( -xx , 0 );
				curveVertex( stage_width / 2 + xx + offsetX , yy + offsetY );
			}
			curveVertex( stage_height / 2 - xx + offsetX , yy + offsetY + 50 );
			t+=0.01;
			flowercounter++;
		}
	}
}