/**
 * Copyright faunus ( http://wonderfl.net/user/faunus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l0fJ
 */

// forked from flashpool's flash on 2011-9-21
package
{
    import org.flixel.*;
    [SWF(width="640", height="480", backgroundColor="#000000")]
    //[Frame(factoryClass="Preloader")]

    public class EZPlatformer extends FlxGame
    {
        public function EZPlatformer()
        {
            super(320,240,PlayState,2);
            forceDebugger = true;
        }
    }
}

import org.flixel.*;
import org.flixel.system.FlxPreloader;

     class PlayState extends FlxState
    {
        public var level:FlxTilemap;
        public var exit:FlxSprite;
        public var coins:FlxGroup;
        public var player:FlxSprite;
        public var score:FlxText;
        public var status:FlxText;

        override public function create():void
        {
            //Set the background color to light gray (0xAARRGGBB)
            FlxG.bgColor = 0xffaaaaaa;

            //Design your platformer level with 1s and 0s (at 40x30 to fill 320x240 screen)
            var data:Array = new Array(
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1,
                1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
                1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
                1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1,
                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 );

            //Create a new tilemap using our level data
            level = new FlxTilemap();
            level.loadMap(FlxTilemap.arrayToCSV(data,40),FlxTilemap.ImgAuto,0,0,FlxTilemap.AUTO);
            add(level);

            //Create the level exit, a dark gray box that is hidden at first
            exit = new FlxSprite(35*8+1,25*8);
            exit.makeGraphic(14,16,0xff3f3f3f);
            exit.exists = false;
            add(exit);

            //Create coins to collect (see createCoin() function below for more info)
            coins = new FlxGroup();
            //Top left coins
            createCoin(18,4);
            createCoin(12,4);
            createCoin(9,4);
            createCoin(8,11);
            createCoin(1,7);
            createCoin(3,4);
            createCoin(5,2);
            createCoin(15,11);
            createCoin(16,11);

            //Bottom left coins
            createCoin(3,16);
            createCoin(4,16);
            createCoin(1,23);
            createCoin(2,23);
            createCoin(3,23);
            createCoin(4,23);
            createCoin(5,23);
            createCoin(12,26);
            createCoin(13,26);
            createCoin(17,20);
            createCoin(18,20);

            //Top right coins
            createCoin(21,4);
            createCoin(26,2);
            createCoin(29,2);
            createCoin(31,5);
            createCoin(34,5);
            createCoin(36,8);
            createCoin(33,11);
            createCoin(31,11);
            createCoin(29,11);
            createCoin(27,11);
            createCoin(25,11);
            createCoin(36,14);

            //Bottom right coins
            createCoin(38,17);
            createCoin(33,17);
            createCoin(28,19);
            createCoin(25,20);
            createCoin(18,26);
            createCoin(22,26);
            createCoin(26,26);
            createCoin(30,26);

            add(coins);

            //Create player (a red box)
            player = new FlxSprite(FlxG.width/2 - 5);
            player.makeGraphic(10,12,0xffaa1111);
            player.maxVelocity.x = 80;
            player.maxVelocity.y = 200;
            player.acceleration.y = 200;
            player.drag.x = player.maxVelocity.x*4;
            add(player);

            score = new FlxText(2,2,80);
            score.shadow = 0xff000000;
            score.text = "SCORE: "+(coins.countDead()*100);
            add(score);

            status = new FlxText(FlxG.width-160-2,2,160);
            status.shadow = 0xff000000;
            status.alignment = "right";
            switch(FlxG.score)
            {
                case 0: status.text = "Collect coins."; break;
                case 1: status.text = "Aww, you died!"; break;
            }
            add(status);
        }

        //creates a new coin located on the specified tile
        public function createCoin(X:uint,Y:uint):void
        {
            var coin:FlxSprite = new FlxSprite(X*8+3,Y*8+2);
            coin.makeGraphic(2,4,0xffffff00);
            coins.add(coin);
        }

        override public function update():void
        {
            //Player movement and controls
            player.acceleration.x = 0;
            if(FlxG.keys.LEFT)
                player.acceleration.x = -player.maxVelocity.x*4;
            if(FlxG.keys.RIGHT)
                player.acceleration.x = player.maxVelocity.x*4;
            if(FlxG.keys.justPressed("SPACE") && player.isTouching(FlxObject.FLOOR))
                player.velocity.y = -player.maxVelocity.y/2;

            //Updates all the objects appropriately
            super.update();

            //Check if player collected a coin or coins this frame
            FlxG.overlap(coins,player,getCoin);

            //Check to see if the player touched the exit door this frame
            FlxG.overlap(exit,player,win);

            //Finally, bump the player up against the level
            FlxG.collide(level,player);

            //Check for player lose conditions
            if(player.y > FlxG.height)
            {
                FlxG.score = 1; //sets status.text to "Aww, you died!"
                FlxG.resetState();
            }
        }

        //Called whenever the player touches a coin
        public function getCoin(Coin:FlxSprite,Player:FlxSprite):void
        {
            Coin.kill();
            score.text = "SCORE: "+(coins.countDead()*100);
            if(coins.countLiving() == 0)
            {
                status.text = "Find the exit.";
                exit.exists = true;
            }
        }

        //Called whenever the player touches the exit
        public function win(Exit:FlxSprite,Player:FlxSprite):void
        {
            status.text = "Yay, you won!";
            score.text = "SCORE: 5000";
            Player.kill();
        }
    }


