/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l0It
 */

/**
 * 2つ以上のtweenをつなげる方法を2通り検証します
 * 
 * 1. delay指定したtweenをparallelで実行する方法
 * 2. tweenをserialで実行する方法
 * 
 * どちらの場合でも制御上問題なさそうなので
 * TPOに合わせて使い分ければよい感じです
 */
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import com.bit101.components.*;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Quart;
	import org.libspark.betweenas3.events.TweenEvent;
	import org.libspark.betweenas3.tweens.ITween;
	
	public class Sequence extends Sprite
	{
		private var _t1:ITween;
		private var _t2:ITween;
		
		private var _slider:HUISlider;
		
		public function Sequence():void
		{
			Logger.initialize(this, 0, 0, 465, 400);
			
			_t1 = _createSequenceUsingParallel();
			_t2 = _createSequenceUsingSerial();
			
			//----------------------------------------
			//ui
			new PushButton(this,  10, 430, "play()", _play);
			new PushButton(this, 120, 430, "stop()", _stop);
			new PushButton(this, 230, 430, "togglePause()", _togglePause);
			( new CheckBox(this, 340, 435, "stopOnComplete", _stopOnComplete) ).selected = _t1.stopOnComplete = _t2.stopOnComplete = false;
			_slider = new HUISlider(this, 10, 400, "position", _position);
			_slider.width   = 465;
			_slider.maximum = _t1.duration;
			_t1.addEventListener(TweenEvent.UPDATE, function():void { _slider.value = _t1.position; } );
		}
		
		/**
		 * BetweenAS3.parallelとdelayを使うパターン
		 * tween同士の継ぎ目に空白時間を作ることができる
		 */
		private function _createSequenceUsingParallel():ITween
		{
			new Label(this, 0, 90, "parallel & delay");
			
			var box1:Sprite = Box.create(this, 100, 100);
			var box2:Sprite = Box.create(this, 260, 100);
			
			var t1:ITween = BetweenAS3.tween(box1, { x: 240 }, null, 1.0, Quart.easeOut);
			var t2:ITween = BetweenAS3.tween(box2, { x: 400 }, null, 1.0, Quart.easeOut);
			
			t2 = BetweenAS3.delay(t2, 1.0);
			
			return BetweenAS3.parallel(t1, t2);
		}
		
		/**
		 * BetweenAS3.serialを使うパターン
		 * 個々のtween時間を変更する時に他のtweenを書き直す手間が要らない
		 */
		private function _createSequenceUsingSerial():ITween
		{
			new Label(this, 0, 290, "serial");
			
			var box1:Sprite = Box.create(this, 100, 300);
			var box2:Sprite = Box.create(this, 260, 300);
			
			var t1:ITween = BetweenAS3.tween(box1, { x: 240 }, null, 1.0, Quart.easeOut);
			var t2:ITween = BetweenAS3.tween(box2, { x: 400 }, null, 1.0, Quart.easeOut);
			
			return BetweenAS3.serial(t1, t2);
		}
		
		private function _play(e:MouseEvent):void
		{
			_t1.play();
			_t2.play();
		}
		
		private function _stop(e:MouseEvent):void
		{
			_t1.stop();
			_t2.stop();
		}
		
		private function _togglePause(e:MouseEvent):void
		{
			_t1.togglePause();
			_t2.togglePause();
		}
		
		private function _stopOnComplete(e:MouseEvent):void
		{
			_t1.stopOnComplete = !_t1.stopOnComplete;
			_t2.stopOnComplete = !_t2.stopOnComplete;
		}
		
		private function _position(e:Event):void
		{
			_t1.gotoAndStop(_slider.value);
			_t2.gotoAndStop(_slider.value);
		}
	}
}

import flash.display.*;
import flash.text.*;

/**
 * Tweenターゲットの生成
 */
internal class Box
{
	static public function create(base:DisplayObjectContainer, x:Number, y:Number, color:uint = 0x000000):Sprite
	{
		var o:Sprite = base.addChild( new Sprite() ) as Sprite;
		o.x = x;
		o.y = y;
		var g:Graphics = o.graphics;
		g.beginFill(color);
		g.drawRect(-10, -10, 20, 20);
		g.endFill();
		return o;
	}
}

/**
 * ログ出力
 */
internal class Logger
{
	static private var _field:TextField;
	static private var _index:uint;
	
	static public function initialize(base:DisplayObjectContainer, x:Number = 0, y:Number = 0, width:Number = 465, height:Number = 465):void
	{
		_field                   = new TextField();
		_field.x                 = x;
		_field.y                 = y;
		_field.width             = width;
		_field.height            = height;
		_field.selectable        = false;
		_field.defaultTextFormat = new TextFormat("MS GOTHIC");
		
		_index = 0;
		
		base.addChild(_field);
	}
	
	static public function trace(...m):void
	{
		_field.text = ("    " + String(_index++)).substr(-5, 5) + "  " + m.join(", ") + "\n" + _field.text;
	}
	
	static public function clear(...m):void
	{
		_field.text = "";
		_index = 0;
	}
}