/**
 * Copyright kinescript ( http://wonderfl.net/user/kinescript )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kzpx
 */

// forked from kotobuki's RGBCube for AS3
package {
    import flash.events.Event;

    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.*;
    
    import funnel.*;

    [SWF(backgroundColor="0x808080")]

    public class MeasuringTheTilt_Accelerometer extends BasicView {
        // 立方体
        private var cube:Cube;
        private var gio:Gainer;
        private var pinX:Pin;
        private var pinY:Pin;
        private var pinZ:Pin

        public function MeasuringTheTilt_Accelerometer() {
            // 立方体のためのマテリアルを準備
            gio = new Gainer();
            pinX = gio.analogInput(0);
            pinX.addFilter(new Scaler(0.3, 0.7, -90, 90, Scaler.LINEAR, true));
            pinX.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            pinY = gio.analogInput(1);
            pinY.addFilter(new Scaler(0.3, 0.7, -90, 90, Scaler.LINEAR, true));
            pinY.addFilter(new Convolution(Convolution.MOVING_AVERAGE));            
            
            var materialsList:MaterialsList = new MaterialsList();
            materialsList.addMaterial(new ColorMaterial(0xFF0000), "front");
            materialsList.addMaterial(new ColorMaterial(0x00FF00), "back");
            materialsList.addMaterial(new ColorMaterial(0x0000FF), "right");
            materialsList.addMaterial(new ColorMaterial(0xFFFF00), "left");
            materialsList.addMaterial(new ColorMaterial(0xFF00FF), "top");
            materialsList.addMaterial(new ColorMaterial(0x00FFFF), "bottom");

            // 立方体のインスタンスを生成
            cube = new Cube(materialsList, 200, 200, 200);
            scene.addChild(cube);

            // カメラをセット
            camera.x = 0;
            camera.y = 0;
            camera.z = -500;
            camera.focus = 500;
            camera.zoom = 1;

            // レンダリング開始
            startRendering();
        }

        override protected function onRenderTick(event:Event = null):void {
            cube.rotationZ =pinY.value;
            cube.rotationX =pinX.value;
            
            // 立方体の角度をセット
            /*
            cube.rotationZ = (stage.mouseX / stage.width - 0.5) * 180;
            cube.rotationX = (stage.mouseY / stage.height - 0.5) * 180;
            */

            // シーンをレンダリング
            renderer.renderScene(scene, camera, viewport);
        }
    }
}