/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kzh3
 */

// forked from WLAD's Resizable Text
package {
    import flash.geom.Rectangle;
    import flash.events.KeyboardEvent;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.events.TextEvent;
    import flash.events.MouseEvent;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {

        private static const MIN_W:Number = 100;
        private static const MAX_W:Number = 400;
        private static const MIN_H:Number = 50;
        private static const MAX_H:Number = 300;
        
        private var tf:TextFormat;
        private var t:TextField;
        
        private var boxes:Vector.<Box>;
        
        public function FlashTest() {
            
            tf = new TextFormat("Arial",24,0xFF0000,true);
            t = new TextField();
            t.setTextFormat(tf);
            t.defaultTextFormat = tf;
            addChild(t);
            t.y = t.x = 200;
            t.text = "くりっくして、この文字を消して書く";
            t.width = 200;
            t.height = 60;
            t.wordWrap = true;
            t.multiline = true;    
            
            boxes = new Vector.<Box>();
            var count:int = 0;
            var b:Box;
            while(count < 4)
            {
                b = new Box(onTextResize);
                b.id = boxes.push(b) - 1;
                addChild(b);       
                count++;
            }

            textNormal();
            textAutoSize();

            t.addEventListener(MouseEvent.MOUSE_DOWN,startEdit);

        }
        
        private function textNormal():void
        {
            t.selectable = false;
            t.type = "dynamic";
            t.border = false;
            t.background = false;
            stage.focus = null;
            t.scrollV = 0;
            stage.removeEventListener(KeyboardEvent.KEY_UP,textAutoSize);
        }
        
        private function textInput():void
        {
            t.selectable = true;
            t.type = "input";
            t.border = true;
            t.background = true;
            t.backgroundColor = 0xEEEEEE;
            stage.focus = t;
            stage.addEventListener(KeyboardEvent.KEY_UP,textAutoSize);
        }
        
        private function textAutoSize(o:* = null):void
        {
            //t.width = t.textWidth + 5;
            //t.height = t.textHeight;                
        }
        
        private function hideBoxes():void
        {
            for(var i:int = 0; i < boxes.length; i++) { boxes[i].visible = false; }
        }
        private function showBoxes():void
        {
            for(var i:int = 0; i < boxes.length; i++) { boxes[i].visible = true; }
        }

        private function updateBoxes(target:int = -1):void
        {
            var b:Box;
            if(target == -1)
            {
                b = boxes[0];
                b.x = t.x;
                b.y = t.y;
                //b.dragBounds = new Rectangle(-MAX_W,-MAX_W,t.x + MAX_W,t.y + MAX_W);
                
                b = boxes[1];
                b.x = t.x + t.width;
                b.y = t.y;
                
                b = boxes[2];
                b.x = t.x + t.width;
                b.y = t.y + t.height;
                
                b = boxes[3];
                b.x = t.x;
                b.y = t.y + t.height;
            } else if(target == 0) {
                
                b = boxes[0];  
                boxes[3].x = t.x = b.x;
                boxes[1].y = t.y = b.y;
                t.width = boxes[1].x - b.x;
                t.height = boxes[3].y - b.y;
                
            } else if(target == 1) {
                
                b = boxes[1]; 
                boxes[2].x = b.x; 
                boxes[0].y = t.y = b.y;
                t.width = b.x - boxes[0].x;
                t.height = boxes[2].y - b.y;
                
            } else if(target == 2) {
                
                b = boxes[2];
                boxes[1].x = b.x;
                boxes[3].y = b.y;
                t.height = b.y - boxes[1].y;
                t.width = b.x - boxes[3].x;
                
            } else if(target == 3) {
                
                b = boxes[3];
                boxes[0].x = t.x = b.x;
                boxes[2].y = b.y;
                t.width = boxes[2].x - b.x;
                t.height = b.y - boxes[0].y;
                
            } else {
                t.text = "wtf?";
            }

        }





        private function startEdit(e:MouseEvent):void
        {
            t.removeEventListener(MouseEvent.MOUSE_DOWN,startEdit);
            stage.addEventListener(MouseEvent.MOUSE_DOWN,disableEdit);
            t.addEventListener(MouseEvent.MOUSE_DOWN,moveText);
            
            textInput();
            textAutoSize();
            showBoxes();
            updateBoxes();
        }
        
        private var p:Point;
        
        private function moveText(e:MouseEvent):void
        {
            t.removeEventListener(MouseEvent.MOUSE_DOWN,moveText);
            stage.removeEventListener(MouseEvent.MOUSE_DOWN,disableEdit);
            t.addEventListener(Event.ENTER_FRAME,onMoveText); 
            stage.addEventListener(MouseEvent.MOUSE_UP,stopMove);    
            
            textNormal();
            t.border = true;
            t.background = true;
            
            p = new Point(t.mouseX,t.mouseY);
        }
        
        private function onMoveText(e:Event):void
        {
            t.x = mouseX - p.x;
            t.y = mouseY - p.y;
            updateBoxes();
        }
        
        private function stopMove(e:MouseEvent):void
        {
            t.removeEventListener(Event.ENTER_FRAME,onMoveText); 
            stage.removeEventListener(MouseEvent.MOUSE_UP,stopMove);
            stage.addEventListener(MouseEvent.MOUSE_DOWN,disableEdit);
            t.addEventListener(MouseEvent.MOUSE_DOWN,moveText);
            stage.addEventListener(KeyboardEvent.KEY_UP,textAutoSize);
            
            textInput();
            updateBoxes();
        }

        private function disableEdit(e:MouseEvent):void
        {
            if(e.target == t || e.target is Box) return;
            
            stage.removeEventListener(MouseEvent.MOUSE_DOWN,disableEdit);
            t.addEventListener(MouseEvent.MOUSE_DOWN,startEdit);
            stage.removeEventListener(KeyboardEvent.KEY_UP,textAutoSize);
            
            hideBoxes();
            textNormal();
        }
        
        private function onTextResize(e:Event):void
        {
            var b:Box = e.target as Box;
            updateBoxes(b.id);
        }
    }
}
import flash.events.Event;
import flash.geom.Rectangle;
import flash.events.MouseEvent;
import flash.display.Graphics;
import flash.display.Sprite;
class Box extends Sprite
{
    private var f:Function;
    public var id:int = 0;
    public var dragBounds:Rectangle;
    
    public function Box(onDrag:Function)
    {
        f = onDrag;
        
        var g:Graphics = graphics;
        g.lineStyle(.1,0x0);
        g.beginFill(0xFFFFFF);
        g.drawRect(-5,-5,10,10);
        g.endFill();
        
        dragBounds = new Rectangle(0,0,1000,1000);
        
        addEventListener(MouseEvent.MOUSE_DOWN,onStartDrag);
    }
    private function onStartDrag(e:MouseEvent):void
    {
        this.startDrag(true,dragBounds);
        stage.addEventListener(MouseEvent.MOUSE_UP,onStopDrag);
        this.removeEventListener(MouseEvent.MOUSE_DOWN,onStartDrag);
        this.addEventListener(Event.ENTER_FRAME,f);
    }
    
    private function onStopDrag(e:MouseEvent):void
    {
        stage.removeEventListener(MouseEvent.MOUSE_UP,onStopDrag);
        this.stopDrag();
        this.removeEventListener(Event.ENTER_FRAME,f);
        addEventListener(MouseEvent.MOUSE_DOWN,onStartDrag);
    }
}