/**
 * Copyright Geo877 ( http://wonderfl.net/user/Geo877 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kyp3
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class RocketSimulation extends Sprite {
        private var groundPlane:Sprite = new Sprite();
        private var planeWidth:Number = 500;
        private var planeHeight:Number = 4;
        private var groundYOffset:Number = 450;
         //F = k*P_0*e(-h/h_0)*v*v
        private var rocket:Sprite = new Sprite();
        private var diameter:Number = 6;
        private var length:Number = 50;
        private var A:Number = Math.PI*(diameter/2); //cross-sectional area
        private var p_0:Number = 101000;//pressure at ground (kg·m−1·s−2)
        private var v:Number = 0;//velocity (m/s)
        private var h:Number = 0;//height above ground
        private var k:Number = 1;//arbitrary Drag Constant
        private var m:Number = 1;//mass in kg
         //Simulation Details
        private var g:Number = 9.81;
        private var scale:Number = 1;//pixels per meter
        private var dt:Number = 0.015;//seconds
        
        
        public function RocketSimulation() {
            inittrace(stage);
            doGraphics();
            addEventListener(Event.ENTER_FRAME,timeStep);
        }
        
        private function doGraphics():void{
            rocket.graphics.beginFill(0x8c988e,1);
            rocket.graphics.drawRect(-tp(diameter)/2,0,tp(diameter),-tp(length));
            rocket.graphics.endFill();
            this.addChild(rocket);
            rocket.x = this.stage.stageWidth/2;
            rocket.y = groundYOffset;
           
            groundPlane.graphics.beginFill(0x3d5223,1);
            groundPlane.graphics.drawRect(0,0,planeWidth,planeHeight);
            groundPlane.graphics.endFill();
            this.addChild(groundPlane);
            groundPlane.y=groundYOffset;
        }
        
        private function timeStep(e:Event = null):void{
            var F_d:Number = k*p_0*A*v*v;
            var F_u:Number = 150;
            var F_g:Number = m*g;
            var F:Number = F_u-F_g;

            var a:Number = F/m;
            v+=a*dt*dt;
            h += v*dt;
            trace(h);
            
            rocket.y = heightToY(h);
        }

        
        private function tp(meters:Number):Number{ //Meters To Pixels
            return scale*meters;
        }
        
        private function heightToY(height:Number):Number{
            return groundYOffset-tp(height);
        }



    }
}



/////  WONDERFL TRACE /////

import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


function inittrace(s:Stage):void
{
    WTrace.initTrace(s);
}

//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            trace_stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
}




