/**
 * Copyright Makoto_Tanaka ( http://wonderfl.net/user/Makoto_Tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kykb
 */

// forked from Makoto_Tanaka's BitmapTest 2010-3-6
package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.events.MouseEvent
    import flash.geom.ColorTransform;
    
    
    [SWF (width=465,height=465,backgroundColor=0)]
    public class BitmapDataSample extends Sprite {
    		
    		private const MAX_COUNT:uint = 50;
    		
    		private var _count:uint;
    		private var _bmpData:BitmapData;
    		private var _sprite:Sprite;
    		private var _matrix:Matrix;
    		private var _colorTrans:ColorTransform;
    		private var _degree:uint;
    		
    		public function BitmapDataSample() {
    			_count = 0;
    			
            //BitmapDataを作成して表示リストに追加
            _bmpData = new BitmapData( 465, 465, false, 0);
            addChild( new Bitmap(_bmpData) );
            
            // グラフィックの作成
            _sprite = newFig( 232, 232, 300, 0xFFFFFF );
            
            _colorTrans = new ColorTransform();
            
            // BitmapDataへ描画
            _bmpData.draw( _sprite );
            
            // Matrixの初期化
            _matrix = new Matrix();
            
            // イベント
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
            stage.addEventListener( MouseEvent.CLICK, reset );
        }
        
        
        private function newFig( cx_:Number, cy_:Number, size_:Number, col_:uint):Sprite {
        		
        		// 中心(cx_,cy_),幅高さsize_, 色col_, のグラフィックを生成
        		var shape:Sprite = new Sprite();
        		shape.graphics.lineStyle( 0, 0x000000, 0.3 );
        		shape.graphics.beginFill( col_ );
        		shape.graphics.drawCircle( cx_, cy_, size_*0.5 );
        		shape.graphics.drawCircle( cx_, cy_, size_*0.4 );
        		var w:Number = size_ * 0.6;
        		var h:Number = size_ * 0.15;
        		shape.graphics.drawRect( cx_ - w/2, cy_ - h/2, w, h );
        		shape.graphics.endFill();
        		
        		return shape;
        }
        
        private function onEnterFrame(e:Event):void {
        		// 数が最大数を超えていないか確認する
        		if ( _count == MAX_COUNT ) {
        			reset(null);
        			_count = 0;
        		}
        		
        		// 位置、角度の調整
        		_matrix.identity();
        		var s:Number = Math.random() * 2;
        		_matrix.scale( s, s );
        		_matrix.rotate( Math.PI * Math.random() );
        		var radian:Number = Math.PI / 180 * _degree;
        		_matrix.translate( (stage.width/2)+Math.sin(radian), (stage.height/2)+Math.cos(radian) );
        		_degree += 4;
        		
        		// 色変更
 			_colorTrans.greenMultiplier = mouseX / 465;
 			_colorTrans.blueMultiplier = mouseY / 465;
 			_colorTrans.alphaMultiplier = Math.random();
 			
 			// BitmapDataへ描画
        		_bmpData.draw( _sprite, _matrix, _colorTrans, BlendMode.ADD );
        		_count++;
        }
        
        private function reset(e:MouseEvent):void {
        		_bmpData.fillRect( _bmpData.rect, 0xFF000000 );
        }
    }
}