/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kyOG
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
    public class Main extends Sprite
    {
        private var tf:TextField;
        private var source:BitmapData;
        private var tmp:BitmapData;
        private var canvas:BitmapData;
        private var perlinBmpd:BitmapData;
        private var seed:Number;
        private var offset:Array;
        private var count:int;
        
        public function Main()
        {
            tf = new TextField;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.defaultTextFormat = new TextFormat(null, 150, 0xffffff);
            tf.text = "Fire !!";
            
            source     = new BitmapData(465, 465, true, 0x000000);
            tmp        = source.clone();
            perlinBmpd = source.clone();
            canvas     = source.clone();
            addChild(new Bitmap(canvas));
            
            seed=Math.floor(Math.random() * 10);
            offset=[new Point(0, 0), new Point(0, 0)];
            count = 0;
            
            source.draw(tf, new Matrix(1,0,0,1,(465-tf.width)*0.5, (465-tf.height)*0.5));    
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        private function onFrame(e:Event):void
        {
            count ++;
            if(count%2==0)
            {
                perlinBmpd.perlinNoise(30, 30, 2, seed, false, true,1 , false, offset);
                offset[0].x+=4;
                offset[1].y+=4;
            }
            
            // 文字をBitmapDataにdraw (ColorTransformで黄色にする) 
            tmp.draw(source, null, new ColorTransform(1,1,0));
            // 上へスクロール
            tmp.scroll(0,-2);
            // フィルターを使ってぼかしつつ赤色へ変化
            tmp.applyFilter(tmp, tmp.rect, new Point, new BlurFilter(4,4,1));
            tmp.applyFilter(tmp, tmp.rect, new Point, new ColorMatrixFilter([1,0,0,0,1,0,0.9,0,0,1,0,0,0.9,0,1,0,0,0,0.95,1])); 
            // DisplacementMapFilterで変化をつける
            canvas.applyFilter(tmp, tmp.rect, new Point,new DisplacementMapFilter(perlinBmpd, new Point, 1, 1, 20, 20));
            // 元の文字（白）を再描写
            canvas.draw(source);
        }
    }
}