/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kxuc
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
    public class FlashTest extends Sprite {
		private var _array:Array;
		
        public function FlashTest() {
			_array = new Array();
			
			var center:Sphere = new Sphere(232.5, 232.5, 0, 0);
			this.addChild(center);
			_array.push(center);
			
			var count:uint = 8;
			for (var index:uint = 0; index < count; ++index) {
				var s:Sphere = new Sphere(0, 0, 100, Math.PI * 2 * (0.125 * index));
				center.addChild(s);
				_array.push(s);
				for (var index2:uint = 0; index2 < count; ++index2) {
					var s2:Sphere = new Sphere(0, 0, 20, Math.PI * 2 * (0.125 * index2));
					s.addChild(s2);
					_array.push(s2);
				}
			}
			
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			for each (var s:Sphere in _array) {
				s.update();
			}
		}
    }
}
import flash.display.Sprite;
import flash.geom.Point;

class Sphere extends Sprite {
	private var _x:Number;
	private var _y:Number;
	private var _radius:Number;
	private var _angle:Number;
	private var _past:/*Point*/Array;
	
	public function Sphere(x:Number, y:Number, radius:Number, angle:Number) {
		_x = x;
		_y = y;
		_radius = radius;
		_angle = angle;
		_past = new Array();
	}
	
	public function update():void {
		_angle += Math.PI * 2 * 0.01;
		if (_angle > Math.PI * 2) _angle -= Math.PI * 2;
		var cos:Number = Math.cos(_angle);
		var sin:Number = Math.sin(_angle);
		
		this.x = _x + (cos * _radius);
		this.y = _y + (sin * _radius);
		_past.push(new Point(cos * _radius, sin * _radius));
		
		if (_past.length > 10) {
			_past.splice(0, 1);
		}
		
		draw();
	}
	
	private function draw():void {
		this.graphics.clear();
		for (var index:uint = 0; index < _past.length; ++index) {
			this.graphics.beginFill(0x000000, 1.0 - (0.1 * (_past.length - index)));
			this.graphics.drawCircle(_past[index].x, _past[index].y, 4);
			this.graphics.endFill();
		}
	}
}