/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kx9V
 */

// forked from _wonder's 加速度を変化させる（上下左右）
// forked from _wonder's 加速度を変化させる（左右）
// forked from _wonder's 加速するボール
// forked from _wonder's base
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    
    public class Acceleration extends Sprite {
    	
    		private var ball:Ball;
    		private var vx:Number = 0;
    		private var vy:Number = 0;
    		private var ax:Number = 0;
    		private var ay:Number = 0;
    		private var gravity:Number = 0.1;
    		
        public function Acceleration() {
            init();            
        }
        
        private function init():void {
        		ball = new Ball();
        		addChild( ball );
        		ball.x = stage.stageWidth / 2;
        		ball.y = stage.stageHeight / 2;
        		addEventListener(Event.ENTER_FRAME, onEnterFrame);
        		stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        		stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
        		if(e.keyCode == Keyboard.LEFT){
        			ax = -0.2;
        		} else if( e.keyCode == Keyboard.RIGHT){
        			ax = 0.2;
        		} else if( e.keyCode == Keyboard.UP){
        			ay = -0.2;
        		} else if( e.keyCode == Keyboard.DOWN){
        			ay = 0.2
        		}
        }
        
        private function onKeyUp(e:KeyboardEvent):void {
        		ax = 0;
        		ay = 0;
        }
        
        private function onEnterFrame(e:Event):void {
        		vx += ax;
        		vy += ay;
        		vy += gravity;
        		ball.x += vx;
        		ball.y += vy;
        }
    }
}

import flash.display.Sprite;

class Ball extends Sprite {
	public var radius:Number;
	public var color:uint;
	
	public function Ball(radius:Number=40, color:uint=0Xff0000){
		this.radius = radius;
		this.color = color;
		init();
	}
	
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}