/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kx48
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    
    [SWF(width="465", height="465", frameRate="60")]
    
    public class FlashTest extends Sprite {
        public static const WIDTH:int = 465;
        public static const HEIGHT:int = 465;
        
        private var _field:Field;
        
        public function FlashTest():void {
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);            
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            _field = new Field();
            _field.Initialize();
            var rect:Rectangle = _field.getRect(_field);
            _field.x = WIDTH / 2 - rect.left - rect.width / 2;
            _field.y = HEIGHT / 2 - rect.top - rect.height / 2;
            addChild(_field);
            
            addEventListener(Event.ENTER_FRAME, EnterFrameHandler);
        }
        
        private function EnterFrameHandler(e:Event):void
        {
            _field.Update();
        }
    }
}

import flash.geom.Point;
import flash.display.Sprite;
import flash.display.Shape;
import flash.display.Graphics;

class Field extends Sprite
{
    public static const GRID_W:int = 12;
    public static const GRID_W:int = 6;
    
    private var _blocks:Array;
    private var _step:int = 0;
    
    public function Field()
    {
        
    }
    
    public function Initialize():void
    {
        _blocks = new Array(_fieldHeight);
        for(var h:int=0; h<_fieldHeight; h++)
        {
            _blocks[h] = new Array(_fieldWidth);
            for(var w:int=0; w<_fieldWidth; w++)
            {
                blocks[h][w] = new Block(0x999999, 0xAAAAAA, 0xCCCCCC, 0x0, 0, 100, GRID_W, GRID_H);
            }
        }
        Draw();
    }
    
    public function Update():void
    {
        var x:int, y:int;
        var xrate:Array = new Array(_fieldWidth);
        var yrate:Array = new Array(_fieldHeight);
        for(x=0;x<_fieldWidth;x++)
        {
            xrate[x] = Math.cos(((x*10 + _step)%360) * Math.PI / 180);
        }
        for(y=0;y<_fieldHeight;y++)
        {
            yrate[y] = Math.sin(((y*10+_step)%360) * Math.PI / 180);
        }
        for(y=0; y<_fieldHeight; y++)
        {
            for(x = 0; x < _fieldWidth; x++)
            {
                var block:Block = _block[y][x];
                block.blockheight = 90 + 4 * xrate[x] * 4 * yrate[y];
            }
        }
        Draw();
        _step += 4;
    }
    
    public function Draw():void
    {
        var g:Graphics = this.graphics;
        g.clear();
        for(var y:int=0; y<_fieldHeight; y++)
        {
            for(var x:int=0; x<_fieldWidth; x++)
            {
                var block:Block = _blocks[y][x];
                var pos:Point = GetGridPosition(x, y);
                block.Draw(g, pos.x, pos.y);
            }
        }
    }
    
    public function GetGridPosition(x:int, y:int):Point
    {
        var tmpx:Number = 0;
        var tmpy:Number = 0;
        
        tmpx = x * GRID_W / 2 - y * GRID_W / 2;
        tmpy = x * GRID_H / 2 + y * GRID_H / 2;
        
        return new Point(tmpx, tmpy);
    }
}


class Block extends Shape
{
    private var _leftColor:uint = 0;
    private var _rightColor:int = 0;
    private var _upColor:uint = 0;
    private var _lineColor:uint = 0;
    private var _lineSize:int = 1;
    private var _blockHeight:Number;
    private var _gridWidth:int;
    private var _gridHeight:int;
    
    public function Block(leftColor:uint, rightColor:uint, upColor:uint, lineColor:uint, lineSize:int, blockHeight:Number, gridHeight:Number, gridWidth:int, gridHeight:int){
        _leftColor = leftColor;
        _rightColor = rightColor;
        _upColor = upColor;
        _lineColor = lineColor;
        _lineSize = lineSize;
        _blockHeight = blockHeight;
        _gridWidth = gridWidth;
        _gridHeight = gridHeight;
        
        Draw(this.graphics);
    }
    
    public function Draw(g:Graphics, x:int = 0, y:int = 0):void
    {
        if(_blockHeight == 0) return;
        
        if(_lineSize > 0) g.lineStyle(_lineSize,_lineColor);
        g.beginFill(_upColor);
        g.moveTo(x,y-_gridHeight*1.5-_blockHeight);
        g.lineTo(x+_gridWidth*0.5, y-_gridHeight-_blockHeight);
        g.lineTo(x,y-_gridHeight*0.5-_blockHeight);
        g.lineTo(x-_gridWidth*0.5, y-_gridHeight-_blockHeight);
        g.lineTo(x,y-_gridHeight*1.5-_blockHeight);
        g.endFill();
        
        g.beginFill(_leftColor);
        g.moveTo(x-_gridWidth*0.5, y-_gridHeight-_blockHeight);
        g.lineTo(x,y-_gridHeight*0.5-_blockHeight);
        g.lineTo(x-_gridWidth*0.5,y);
        g.lineTo(x-_gridWidth*0.5, y-_gridHeight-_blockHeight);
        g.endFill();
        
        g.beginFill(_rightColor);
        g.moveTo(x,y-_gridHeight*0.5-_blockHeight);
        g.lineTo(x+_gridWidth*0.5,y-_gridHeight-_blockHeight);
        g.lineTo(x+_gridWidth*0.5, y);
        g.lineTo(x, y + _gridHeight * 0.5);
        g.lineTo(x, y - _gridHeight * 0.5 - _blockHeight);
        g.endFill();
    }
    
    public function set blockheight(val:int):void {
        _blockHeight = val;
    }



}



