/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kwOS
 */

// forked from civet's forked from: Sakura Particle with Stardust
// forked from clockmaker's Sakura Particle with Stardust
/*
   Sakura Particle with Stardust - FlaMi -

   Flashで花見気分を味わう
   年度末で忙しく桜を見に行けない人たちへ…

   inspired by Stardust Demo
   http://code.google.com/p/stardust-particle-engine/
 */
package {
    import flash.display.*;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.threeD.renderers.DisplayObjectRenderer3D;
    
    [SWF(width="465", height="465", frameRate="60")]
    public class Main extends Sprite {
            private static const WIDTH:int = 465;
        private static const HEIGHT:int = 465;
        private var sky:DisplayObject;
        private var pt:Point = new Point();
        private var blur:BlurFilter = new BlurFilter(16,16,1);
        
        public static var petelBmd:BitmapData;
        private static const CONTEXT:LoaderContext = new LoaderContext(true);
        private var _bmd:BitmapData = new BitmapData(465, 465, true, 0x00000000);
        private var _container:Sprite = new Sprite();
        private var _emitter:SakuraEmitter;
        private var _renderer:DisplayObjectRenderer3D;
        
        public function Main() {
            addChild(_container);
            addChild(new Bitmap(_bmd));
            stage.quality = StageQuality.LOW;
            _emitter = new SakuraEmitter(new SteadyClock(1));
            _renderer = new DisplayObjectRenderer3D(_container);
            _renderer.addEmitter(_emitter);
            _renderer.camera.position.x = 500;
            _renderer.camera.position.y = -200;
            _renderer.camera.position.z = -500;
            _renderer.camera.direction.set(-500, 0, 0);
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
            loader.load(new URLRequest("http://www.gamezarena.com/images/flash-games.gif"), CONTEXT);
        }
        private function onLoadComplete(e:Event):void {
                petelBmd = e.currentTarget.content.bitmapData as BitmapData;
            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, _onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, _onMouseUp);
            
            this.graphics.beginFill(0xffffff);
            this.graphics.drawRect(0, 0, WIDTH, HEIGHT);
            this.graphics.endFill();
            sky = createSky(WIDTH * 2, HEIGHT * 3/4);
        }
        
        private function createSky(w:uint, h:uint):DisplayObject {
            var bg:Shape = new Shape();
            var colors:Array = [0x66ccff, 0xffffff];
            var alphas:Array = [1, 1];
            var ratios:Array = [0x00, 0xFF];
            var mtx:Matrix = new Matrix();
            mtx.createGradientBox(w, h, Math.PI/2, 0, 0);
            bg.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, mtx, SpreadMethod.PAD);
            bg.graphics.drawRect(0, 0, w, h);
            bg.graphics.endFill();
            
            var source:BitmapData = new BitmapData(w, h, true, 0);
            var rect:Rectangle = new Rectangle(0, 0, source.width, source.height);
            var seed:int = Math.random()*100;
            var offset:Point = new Point();
            var trans:ColorTransform = new ColorTransform(1,1,1,2, 255,255,255, -200);
            source.perlinNoise(240, 80, 4, seed, false, true, BitmapDataChannel.ALPHA, false, [offset]);
            source.colorTransform(rect, trans);
            
            var result:BitmapData = new BitmapData(w, h, false, 0xffffff);
            result.draw(bg);
            result.draw(source);
            var bmp:Bitmap = new Bitmap(result);
            this.addChildAt(bmp, 0);
            return bmp;
        }
        
        private function mouseRotate():void {
            DisplayObjectRenderer3D(_renderer).camera.position.z = -(mouseX/WIDTH)* 500;
            DisplayObjectRenderer3D(_renderer).camera.direction.x = -500 + (mouseX/WIDTH)* 500;
            
            var xx:int = -mouseX;
            sky.x = (-WIDTH > xx) ? -WIDTH : (xx > 0) ? 0 : xx;
        }
        
        private function _onEnterFrame(event:Event):void {
            mouseRotate();
            
            _emitter.step();
            _bmd.colorTransform(_bmd.rect, new ColorTransform(1, 1, 1, 0.3));
            _bmd.draw(_container);
            if(mouseDown) _bmd.applyFilter(_bmd, _bmd.rect, pt, blur);
        }
        
        private var mouseDown:Boolean;
        private function _onMouseDown(e:Event):void {
            _emitter.stepTimeInterval = 0.05;
            stage.quality = StageQuality.MEDIUM;
            mouseDown = true;
        }
        
        private function _onMouseUp(e:Event):void {
            _emitter.stepTimeInterval = 1;
            stage.quality = StageQuality.LOW;
            mouseDown = false;
       }
    }
}
import flash.display.*;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.AlphaCurve;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.emitters.Emitter;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.common.particles.Particle;
import idv.cjcat.stardust.threeD.actions.Move3D;
import idv.cjcat.stardust.threeD.actions.StardustSpriteUpdate3D;
import idv.cjcat.stardust.threeD.emitters.Emitter3D;
import idv.cjcat.stardust.threeD.initializers.DisplayObjectClass3D;
import idv.cjcat.stardust.threeD.initializers.Position3D;
import idv.cjcat.stardust.threeD.initializers.Velocity3D;
import idv.cjcat.stardust.threeD.zones.CubeZone;
import idv.cjcat.stardust.twoD.display.StardustSprite;

class SakuraEmitter extends Emitter3D {
    public function SakuraEmitter(clock:Clock) {
        super(clock);
        //initializers
        addInitializer(new DisplayObjectClass3D(SakuraPetalWrapper));
        addInitializer(new Life(new UniformRandom(100, 40)));
        addInitializer(new Position3D(new CubeZone(-200, -900, -200, 1600, 300, 1600)));
        addInitializer(new Velocity3D(new CubeZone(-30, 10, -30, 30, 10, 30)));
        addInitializer(new Scale(new UniformRandom(1.8, 0.3)));
        //actions
        addAction(new Age());
        addAction(new Move3D());
        addAction(new DeathLife());
        addAction(new StardustSpriteUpdate3D());
        addAction(new AlphaCurve(15, 15));
    }
}

class SakuraPetalWrapper extends StardustSprite {
    public function SakuraPetalWrapper() {
        phase = 0;
        petel = new Bitmap(Main.petelBmd);
        innerWrapper = new Sprite();
        innerWrapper.addChild(petel);
        petel.rotation = Math.random() * 360;
        rotation *= Math.random() * 360;
        selfOmega = Math.random() * 10;
        petalOmega = Math.random() * 10;
        scaleXRate = Math.random() * 0.03 + 0.07;
        addChild(innerWrapper);
    }
    private var innerWrapper:Sprite;
    private var petalOmega:Number;
    private var petel:Bitmap;
    private var phase:Number;
    private var scaleXRate:Number;
    private var selfOmega:Number;
    
    override public function update(emitter:Emitter, particle:Particle, time:Number):void {
        petel.rotation += petalOmega * time;
        rotation += selfOmega * time;
        phase += time;
        innerWrapper.scaleX = Math.sin(scaleXRate * phase);
    }
}