/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kvcL
 */

package
{
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.ByteArray;
    
    [SWF(width="465",height="465", backgroundColor="0xFFFFFF")]

    public class BitmapDataColorTest extends Sprite
    {
        private const color1:uint = 0xFFCC9966;
        private const color2:uint = 0x336699CC;
        private const color3:uint = 0x33FFFFFF;
        
        private var t:TextField;
        private var def:TextFormat;
        private var err:TextFormat;
        
        public function BitmapDataColorTest()
        {
            addChild( (t=new TextField()) );
            t.width = t.height = 465;
            
            def = new TextFormat();
            def.color = 0;
            err = new TextFormat();
            err.color = 0xFF0000;
            
            stage.addEventListener(MouseEvent.CLICK, onClick);
            onClick();
        }
        private function onClick( e:MouseEvent = null ):void
        {
            t.text = "";
            t.setTextFormat( def );
            
            $( color1 );
            //$( color1 , false);
            
            $( color2 );
            //$( color2 , false);
            
            $( color3 );
            //$( color3 , false);
            
            var c:uint = 0xFFFFFFFF * Math.random();
            $( c );
            //$( c , false);
        }
        private function $( color:uint , init:Boolean = true):void
        {
            var bd:BitmapData;
            var start:int = t.text.length;
            if(init)
            {
                bd = new BitmapData(1,1,true, color);
                t.appendText( "fillColor true\n" );
            }else
            {
                bd = new BitmapData(1,1,true);
                bd.setPixel32(0,0,color);
                t.appendText( "fillColor null\n" );
            }
            var ba:ByteArray = bd.getPixels( bd.rect );
            ba.position = 0;
            
            t.appendText( "color :: " + color.toString(16) + "\n" );
            t.appendText( "getPixel :: " + bd.getPixel(0,0).toString(16) + "\n" );
            t.appendText( "getPixel32 :: " + bd.getPixel32(0,0).toString(16) + "\n" );
            t.appendText( "Vector :: " + uint(bd.getVector( bd.rect )[0]).toString(16) + "\n" );
            t.appendText( "ByteArray :: " + ba.readUnsignedInt().toString(16) + "\n" );
            
            if( color != bd.getPixel32(0,0) )
            {
                t.appendText("色がずれてるよ\n");
                t.setTextFormat( err, start ,t.text.length);
            }
            t.appendText("\n");
            
            bd.dispose();
            ba.clear();
        }
        
    }
}