/**
 * Copyright MMMMMonchi ( http://wonderfl.net/user/MMMMMonchi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kvWQ
 */

// forked from GreekFellows's Rubber Letter 2
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    /**
     * ...
     * @author Greek Fellows
     */
    public class Main extends Sprite 
    {
        private var array:Array;
        
        private var bd:BitmapData;
        private var b:Bitmap;
        private var s:Sprite;
        
        private const UNIT:int = 1;
        
        public function Main():void 
        {
            this.removeChildren();
            
            // first, get my logo 'gf' out
            text("gf");
            
            // then draw that out with a new bitmap data
            var gfbd:BitmapData = new BitmapData(465, 465);
            gfbd.draw(this); // it can't be gfbd.draw(gf) because then gf will shift to the top left corner
            
            // use an array to store the white 'visible' pixels of the text, using the bitmap data
            this.array = [];
            for (var ver:int = 0; ver < gfbd.height; ver += this.UNIT) {
                for (var hor:int = 0; hor < gfbd.width; hor += this.UNIT) {
                    if (gfbd.getPixel(hor, ver) != 0xffffff) {
                        this.array.push(new Array(
                        { cx:hor-this.UNIT/2, cy:ver-this.UNIT/2, x:hor-this.UNIT/2, y:ver-this.UNIT/2, color:gfbd.getPixel(hor, ver) },
                        { cx:hor-this.UNIT/2, cy:ver+this.UNIT/2, x:hor-this.UNIT/2, y:ver+this.UNIT/2, color:gfbd.getPixel(hor, ver) },
                        { cx:hor+this.UNIT/2, cy:ver+this.UNIT/2, x:hor+this.UNIT/2, y:ver+this.UNIT/2, color:gfbd.getPixel(hor, ver) },
                        { cx:hor+this.UNIT/2, cy:ver-this.UNIT/2, x:hor+this.UNIT/2, y:ver-this.UNIT/2, color:gfbd.getPixel(hor, ver) }
                        ));
                    }
                }
            }
            
            // remove the logo because we won't use it anymore
            this.removeChildren();
            
            // accelerate the graphics by using bitmap data with render mode set to GUI
            bd = new BitmapData(465, 465);
            b = new Bitmap(bd);
            s = new Sprite();
            this.addChild(b);
            
            // now let's have the fun begun...
            this.addEventListener(Event.ENTER_FRAME, rubberletter);
        }
        
        private function rubberletter(e:Event):void {
            s.graphics.clear();
            
            s.graphics.beginFill(0xffffff, 1);
            s.graphics.drawRect(0, 0, 465, 465);
            s.graphics.endFill();
            
            for (var ind:int = 0; ind < this.array.length; ind++) {
                // if mouse is close enough to the point
                s.graphics.beginFill(this.array[ind][0].color, 1);
                for (var dind:int = 0; dind < this.array[ind].length; dind++) {
                    var mp:Point = new Point(mouseX, mouseY);
                    var pp:Point = new Point(this.array[ind][dind].cx, this.array[ind][dind].cy);
                    var d:Number = Point.distance(mp, pp);
                    var angle:Number = Math.atan2( (mp.y - pp.y) , (mp.x - pp.x) ) / Math.PI * 180 - 180;
                    this.array[ind][dind].x += (pp.x + Math.cos(angle * Math.PI / 180) * 200 - this.array[ind][dind].x) / 5;
                    this.array[ind][dind].y += (pp.y + Math.sin(angle * Math.PI / 180) * 200 - this.array[ind][dind].y) / 5;
                    
                    if (dind == 0) {
                        s.graphics.moveTo(this.array[ind][dind].x, this.array[ind][dind].y);
                    } else {
                        s.graphics.lineTo(this.array[ind][dind].x, this.array[ind][dind].y);
                    }
                }
                s.graphics.lineTo(this.array[ind][0].x, this.array[ind][0].y);
                s.graphics.endFill();
            }
            
            bd.draw(s);
        }
        
        private function text(str:String):TextField {
            var tf:TextField = new TextField();
            tf.text = str;
            
            var fm:TextFormat = new TextFormat();
            fm.font = "Segoe UI Light";
            fm.size = 84;
            fm.align = "center";
            
            tf.setTextFormat(fm);
            
            tf.width = tf.textWidth;
            tf.height = tf.textHeight + 5;
            tf.x = 465 / 2 - tf.textWidth / 2;
            tf.y = 465 / 2 - tf.textHeight / 2;
            
            this.addChild(tf);
            
            return tf;
        }
        
    }
    
}