/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kumE
 */

// forked from WLAD's Stage3D test 2
/// @mxmlc -swf-version 21
package 
{
	import flash.display.Sprite;
	import flash.geom.Point;
	import flash.geom.Vector3D;
	import flash.text.TextField;
	import flash.ui.Keyboard;
	
	[SWF(width='465', height='465')]
	public class WFL_oucy6 extends Sprite
	{
		private var sw:int, sh:int;
		public function WFL_oucy6()
		{
			stage.color = 0;
			graphics.beginFill(0); graphics.drawRect(0, 0, 3000, 3000);
			var text:TextField = new TextField(); text.autoSize = 'left'; 
			text.textColor = 0x9A9A9A; stage.addChild(text);
			text.scaleX = text.scaleY = 1.2; text.mouseEnabled = false;
			text.text = "画面左/右　マウス２回クリックで　大小画面と回転が変わります".toUpperCase(); 
			
			var sw:int = stage.stageWidth;
			var sh:int = stage.stageHeight;
			
			var space:Space3D = new Space3D();
			space.addParent( this, sw >> 1, sh >> 1 );
			
			var layers:int = 8;
			var mid_index:Number = (layers - 1) / 2;
			var padding:int = 25;
			C.SIZE = 10;
			C.ALPHA = 0.3;
			var layerCount:int;
			
			var pi2:Number = Math.PI * 2;
			
			for (var z:int = 1; z < layers; z++) {	
				
				layerCount = z == 0 ? 1 : ( z * 6 );
				
				var rDelta:Number = pi2 / layerCount;
				
				var rMax:Number = pi2 - rDelta / 2;
				
				var rDist:Number = (layers-z) * padding;
				
				for (var r:Number = 0; r < rMax; r += rDelta ) 
				{	
					var color:uint;
					if ( z == layers - 1 ) color = HSV2HEX(r*57.2957, 1, 1);
					else {
						var cVal:Number = z / layers;
						color = HSV2HEX( cVal*170+80,1,1);
					}
					
					var circle:C = new C( color );
					
					var p:Point = Point.polar( rDist, r );
					
					space.position( 
						circle, 
						p.x, 
						p.y, 
						(( layers - z ) - mid_index) * padding
					);
				}
			}
			
			// camera vars
			var rotation_speed:Number = 7;
			var rotation_speed_init:Number = 0;
			space.rotate( 0, 4 );
			
			// Enter frame 
			stage.addEventListener('enterFrame', function(e:*):void
			{
				space.rotate(0, 0, (7 - 14 * stage.mouseX / sw) + rotation_speed_init );
				
				//space.display.rotationY = isFS ? -4 : 7;
				text.visible = !isFS;
			});
			
			// Mouse click
			stage.addEventListener('click', function(e:*):void
			{
				space.rotate( 180, 0, 0 );
			});
			
			// Right click 
			stage.addEventListener('rightMouseDown', function(_:*):void
			{rotation_speed_init = rotation_speed_init == 0 ? 60 : 0; });
			
			// Fullscreen
			var isFS:Boolean = false;
			stage.doubleClickEnabled = true;
			stage.addEventListener('doubleClick', function(e:*):void {
				isFS = stage.displayState == 'normal';
				if ( isFS ) stage.displayState = 'fullScreen';
				else stage.displayState = 'normal';
			});
		}
	}
}
import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import flash.display.Shape;
import flash.display.Sprite;


class Space3D 
{
	public var display:Sprite;
	
	public function Space3D()
	{
		display = new Sprite();
		display.mouseChildren = false;
		display.mouseEnabled = false;
	}
	
	public function addParent( parent:DisplayObjectContainer, x:Number = 0, y:Number = 0 ):void 
	{
		parent.addChild( display );
		display.x = x;
		display.y = y;
	}
	
	public function position( target:DisplayObject, x:Number = 0, y:Number = 0, z:Number = 0 ):void
	{
		if( ! target.parent || target.parent != display ) display.addChild( target );
		target.x = x;
		target.y = y;
		target.z = z;
	}
	
	public function rotate( x:Number, y:Number = 0, z:Number = 0 ):void
	{
		display.rotationX += x;
		display.rotationY += y;
		display.rotationZ += z;
	}
	
	public function rotateObjects( x:Number, y:Number = 0, z:Number = 0 ):void
	{
		var child:DisplayObject;
		for (var i:int = 0; i < display.numChildren; i++) 
		{
			child = display.getChildAt( i );
			child.rotationX += x;
			child.rotationY += y;
			child.rotationZ += z;
		}
	}
}

class C extends Shape
{
	static public var SIZE:uint = 10;
	static public var ALPHA:Number = 0.5;
	
	public function C( color:uint = 0xFF0000 )
	{
		graphics.lineStyle(0.1, color);
		graphics.beginFill( color, ALPHA );
		graphics.drawCircle( 0, 0, SIZE );
		graphics.endFill();
		//graphics.moveTo( 0, 0 );
		//graphics.lineTo( 0, SIZE );
	}
}
/**
 * @param	h [0,360]
 * @param	s [0,1]
 * @param	v [0,1]
 * @return HEX color
 */
function HSV2HEX(h:Number, s:Number, v:Number ):uint
{
	var r:Number, g:Number, b:Number;
	var hi:int = Math.floor(h/60) % 6;
	var f:Number = h/60 - Math.floor(h/60);
	var p:Number = (v * (1 - s));
	var q:Number = (v * (1 - f * s));
	var t:Number = (v * (1 - (1 - f) * s));
	switch(hi){
		case 0: r = v; g = t; b = p; break;
		case 1: r = q; g = v; b = p; break;
		case 2: r = p; g = v; b = t; break;
		case 3: r = p; g = q; b = v; break;
		case 4: r = t; g = p; b = v; break;
		case 5: r = v; g = p; b = q; break;
	}
	return (Math.round(r * 255) << 16) | (Math.round(g * 255) << 8) | Math.round(b * 255);
}