/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/krfL
 */






package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Rectangle;

    [SWF(width='465', height='465', frameRate='32')]
    
    public class Slaash extends Sprite
    {
        private var lux : Lux;
        private var lucioles : Lucioles;
        private var output : BitmapData;

        function Slaash()
        {
            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.fullScreenSourceRect = new Rectangle( 0,0,465,465 );
            stage.quality = StageQuality.LOW;
            stage.frameRate = 60;
            opaqueBackground = 0x000000;

            var bm : Bitmap = new Bitmap(output = new BitmapData(465, 465, false));
            bm.opaqueBackground = 0x0;
            addChild(bm);

            lucioles = new Lucioles(465, 465);
            lux = new Lux(465, 465);

            addEventListener(Event.ENTER_FRAME, oef);
        }


        private function oef(e : Event) : void
        {
            var mx : Number = stage.mouseX;
            var my : Number = stage.mouseY;

            lucioles.update(mx, my);

            output.lock();
            lux.render(mx, my, lucioles.bitmapData, output);
            output.unlock();
        }
    }
}






import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.Shape;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;


internal class Lucioles
{
    public  var bitmapData : BitmapData;
    private var trails : Vector.<Vector.<Point>> = new Vector.<Vector.<Point>>();
    private var sh : Shape = new Shape();
    private var ct : ColorTransform = new ColorTransform(0.17, 0.17, 0.97);
    private var cnt : Number = 0;


    public function Lucioles(width : int, height : int)
    {
        bitmapData = new BitmapData(width, height);

        for (var i : int = 0; i < 3; i++) {
            var pts : Vector.<Point> = new Vector.<Point>();
            for (var j : int = 0; j < 3; j++) {
                pts.push(new Point());
            }
            trails.push(pts);
        }
    }

    public function update(tx : Number, ty : Number) : void
    {
        cnt++;

        for (var i : int = 0; i < 3; i++) {
            var inertia : Point = trails[i][0].subtract(trails[i][1]).add(trails[i][0]);
            var ang : Number = (cnt/6) + (6.283185307179586 * (i/3) );
            var amp : Number = 8 + 10 * Math.sin(cnt / 12);

            inertia.x = inertia.x * 0.8 + (tx + Math.cos(ang) * amp) * 0.2;
            inertia.y = inertia.y * 0.8 + (ty + Math.sin(ang) * amp) * 0.2;

            trails[i].unshift(inertia);
            trails[i].length = 2;
        }

        sh.graphics.clear();
        sh.graphics.lineStyle(8.0, 0x800000, 1.0, false, 'none', 'none');

        for (i = 0; i < 3; i++)
        {
            sh.graphics.moveTo(trails[i][0].x, trails[i][0].y);

            var len : int = trails[0].length;
            for (var j : int = 1; j < len; j++)
            {
                sh.graphics.lineTo(trails[i][j].x, trails[i][j].y);
            }
        }

        bitmapData.colorTransform(bitmapData.rect, ct);
        bitmapData.draw(sh);
    }
}

internal class Lux
{
    /* */
    private const passes : uint = 8;
    private const scale : Number = 2.0;
    private const s : Number = 1 + (scale - 1) / (1 << passes);
    /* */
    private var offscr : BitmapData;
    private var ct : ColorTransform = new ColorTransform(0.05, 0.05, 0.05);
    private var mtx : Matrix = new Matrix();
    private var dstp : Point = new Point();
    private var rect : Rectangle;

    public function Lux(width : int, height : int)
    {
        offscr = new BitmapData(width, height);
        rect = new Rectangle(0, 0, width, height);
    }

    public function render(tx : Number, ty : Number, input : BitmapData, output : BitmapData) : void
    {
        output.copyPixels(input, rect, dstp);
        output.colorTransform(rect, ct);

        mtx.identity();
        mtx.translate(-tx, -ty);
        mtx.scale(s, s);
        mtx.translate(tx, ty);

        var n : uint = passes;
        while (n-- != 0)
        {
            offscr.copyPixels(output, rect, dstp);
            output.draw(offscr, mtx, null, BlendMode.ADD, null, true);
            mtx.concat(mtx);
        }
    }
}