/**
 * Copyright Nao_u ( http://wonderfl.net/user/Nao_u )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/krIU
 */

// forked from Nao_u's マウスで描いた線が動く
//    
//
// 上から降ってくる玉をマウスで描いた線で落とさないように
// 壊してください。
//
// 玉は一定時間ごと、もしくはマウスをクリックしたときに
// 追加されます。
//
package {  
    import flash.display.Sprite;  
    import flash.events.*;  
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]   
     
    public class FlashTest extends Sprite {  
        public function FlashTest() {  
            Main = this;  
            startup();     
            initialize();     
            stage.addEventListener(Event.ENTER_FRAME,update);   
            stage.addEventListener(MouseEvent.MOUSE_UP,    MouseCheckUp);    
            stage.addEventListener(MouseEvent.MOUSE_DOWN,  MouseCheckDown);    
         }  
    }  
}          

import flash.display.Sprite;   
import flash.events.Event; 
import flash.events.MouseEvent;    
import flash.geom.*;
import flash.text.TextField; 
import flash.text.TextFormat; 
import flash.text.TextFormatAlign; 
var Text:TextField  
var GameOverText:TextField  
var Main:Sprite;  
var SCREEN_W:Number = 465; 
var SCREEN_H:Number = 465; 

var g_LineLst:Array;
var g_BallLst:Array;
var g_ParticleLst:Array;
var g_Cnt:Number;
var g_CntMax:Number;
var g_Sumi:Number;
var g_SumiMax:Number;
var g_StPos:Point;
var g_GameOver:Boolean;
var g_GameOverCnt:int;
var g_Score:int;
var g_Time:Number;


function startup():void{ 
    Text = new TextField();   
    Text.text = "Scrore:"; 
    Text.autoSize = "left"; 
    Main.addChild(Text);    

    var fm:TextFormat = new TextFormat; 
    fm.font = "_typewriter"; fm.bold = true; 
    fm.size = 48; fm.color = 0x000000; 
    GameOverText = new TextField();   
    GameOverText.defaultTextFormat = fm; 
    GameOverText.text = ""; 
    GameOverText.autoSize = "left"; 
    GameOverText.x = 80;
    GameOverText.y = 128;
    GameOverText.width = 128; 
    Main.addChild(GameOverText);    
}    

function initialize():void{ 
    g_Score = 0;
    g_Time = 0;

    g_LineLst = new Array;
    g_BallLst = new Array;
    g_ParticleLst = new Array;
    g_Cnt = 100;
    g_CntMax = 200;

    g_SumiMax = g_Sumi = 200;

    g_GameOver = false;
    g_GameOverCnt = 0;
    GameOverText.text = ""; 
}  

function update(e :Event):void{  
    Main.graphics.clear(); 
    
    gameUpdate();
    gameDraw();

    MouseUpdate(); 
}

function gameUpdate():void{  

    if( g_GameOver == true ){
        GameOverText.text = "Game Over"; 
        g_GameOverCnt++;
        if( g_GameOverCnt > 60 && MouseData & MOUSE_LEFT_TRG  ){
            initialize();
        }
        return;
    }
    Text.text = "SCORE:" + g_Score.toString();// + "   (wait:" +g_CntMax+")"; 

    if( MouseData & MOUSE_LEFT_TRG && g_Sumi > 0 ){
        g_StPos = new Point( Main.stage.mouseX, Main.stage.mouseY );
        g_LineLst.push( new LineList( new Point( g_StPos.x, g_StPos.y ) ) );
    }
    if( MouseData & MOUSE_LEFT ){
        g_Sumi-= 0.35 + Math.abs(g_StPos.x - Main.stage.mouseX) * 0.01;
        if( g_Sumi < 0 ){
            g_Sumi = 0.0;
        }else{
           g_LineLst[g_LineLst.length-1].addPoint( new Point( Main.stage.mouseX, Main.stage.mouseY ) );
        }
    }else{
        if( g_Sumi < g_SumiMax ) {
            g_Sumi += 1.5;
        }
    }

    var lp:int;
    for( lp=0; lp<g_LineLst.length; lp++ ){
        if( !(lp == g_LineLst.length-1 && MouseData & MOUSE_LEFT && g_Sumi > 0) ) g_LineLst[lp].isEnable = true;
        if( g_LineLst[lp].PosAry.length == 0 ){
            g_LineLst.splice(lp,1);
        }else{
            g_LineLst[lp].update();
        }
    }

    g_Cnt--;
    if( MouseData & MOUSE_LEFT_TRG || g_Cnt <= 0 ){
        var b:Ball = new Ball( new Point( Main.stage.mouseX, -60) , 60 );
        g_BallLst.push( b );
        g_Cnt = 0;    
    }
    if( g_Cnt <= 0 ) {
        g_Cnt += g_CntMax;    
        if( g_CntMax > 100 )       g_CntMax-=2.0;
        else if( g_CntMax > 60 )   g_CntMax-=0.9;
        else if( g_CntMax > 50 )   g_CntMax-=0.17;
        else if( g_CntMax > 40 )   g_CntMax-=0.12;
        else if( g_CntMax > 30 )   g_CntMax-=0.05;
        else                       g_CntMax-=0.010;
    }

    for( lp=0; lp<g_BallLst.length; lp++ ){
        if( g_BallLst[lp].Radius <= 0 ){
            g_BallLst.splice(lp,1);
        }else{
            g_BallLst[lp].update();
        }
    }

    for( lp=0; lp<g_ParticleLst.length; lp++ ){
        if( g_ParticleLst[lp].Radius <= 0 ){
            g_ParticleLst.splice(lp,1);
        }else{
          g_ParticleLst[lp].update();
        }
    }
    
        
} 

function gameDraw():void{
    var lp:int;
    for( lp=0; lp<g_LineLst.length; lp++ ){
        g_LineLst[lp].draw();
    }

    for( lp=0; lp<g_BallLst.length; lp++ ){
        g_BallLst[lp].draw();
    }

    for( lp=0; lp<g_ParticleLst.length; lp++ ){
        g_ParticleLst[lp].draw();
    }

    Main.graphics.lineStyle(5,0xb0b0b0);     
    Main.graphics.moveTo( 10, 455 );     
    Main.graphics.lineTo( 10, 455-g_Sumi );        
}

function setParticle( p:Point, s:Point, r:Number ):void{
    var pt:Particle = new Particle( p, s, r );
    g_ParticleLst.push( pt );
}

class LineList{  
    public var PosAry:Array; 
    public var StartPnt:int;
    public var Mx:Number= 1.005;
    public var isEnable:Boolean = false;
    public function LineList( p:Point ){  
        PosAry = new Array;
        PosAry.push( p );
        PosAry.push( p );
        StartPnt = 0;
    }  


    public function addPoint( p:Point ):void{  
        Main.graphics.lineStyle(3,0xd0d000);
        var l:int = PosAry.length-1;
        var lx:int = PosAry[l-1].x-PosAry[l].x;
        var ly:int = PosAry[l-1].y-PosAry[l].y;
        var len:int = lx*lx + ly*ly;
        var maxLen:int = 1;
        if( len > maxLen*maxLen ){
            PosAry.push( p );
        }else{
            PosAry[l] = p;
        }
    }  

    public function update():void{  
        if( isEnable == false ) return;
        if( PosAry.length == 0 ) return;
        var mi:int = StartPnt-1;
        var pl:int = StartPnt+1;
        if( mi < 0 ) mi = PosAry.length-1;
        if( pl > PosAry.length-1 ) pl = 0;
        var lx:int = PosAry[mi].x - PosAry[StartPnt].x;
        var ly:int = PosAry[mi].y - PosAry[StartPnt].y;
        PosAry[StartPnt].x = PosAry[pl].x + (lx * Mx);
        PosAry[StartPnt].y = PosAry[pl].y + (ly * Mx);

        StartPnt++;

        if( StartPnt > PosAry.length-1 ) {
            var del:int = PosAry.length/20 + 2;
            PosAry.splice(PosAry.length-del,del);
            StartPnt = 0;
        }
    }

    public function pop():void{  
        if( isEnable == false ) return;

        if( PosAry.lenth <= 2 ) return;
        var mi:int = StartPnt-1;
        if( mi < 0 ) mi = PosAry.length-1;
        PosAry.splice(mi,1);
        StartPnt--;
        if( StartPnt < 0 ) StartPnt = PosAry.length-1;
    }

    public function draw():void{  
        if( PosAry.length <= 0 ) return;
        var s:int = StartPnt;

        var size:Number;
        var minX:int = 99999999;
        var minY:int = 99999999;
        var maxX:int = -99999999;
        var maxY:int = -99999999;
        for( var i:int=0; i<PosAry.length-1; i++ ){
            size = i / 8.0;
            if( size > 5.0 ) size = 5.0;
            if( size < 1.5 ) size = 1.5;
            var col:int = 0x40 * (PosAry.length-i) / PosAry.length + 0x60;
            var c:int = (col << 16) + (col << 8) + col;
            Main.graphics.lineStyle(size,c);     

            if( minX > PosAry[s].x ) minX = PosAry[s].x;
            if( minY > PosAry[s].y ) minY = PosAry[s].y;
            if( maxX < PosAry[s].x ) maxX = PosAry[s].x;
            if( maxY < PosAry[s].y ) maxY = PosAry[s].y;
            Main.graphics.moveTo( PosAry[s].x, PosAry[s].y );     
            s++;
            if( s > PosAry.length-1 ) s = 0;
            Main.graphics.lineTo( PosAry[s].x, PosAry[s].y );
            if( s > PosAry.length-1 ) s = 0;
        }
        
        size = PosAry.length/2;
        if( size > 4.5 ) size = 4.5;
        Main.graphics.lineStyle(0,0xc0c0c0);        
        Main.graphics.beginFill(0x000000,1);    
        Main.graphics.drawCircle(PosAry[s].x,PosAry[s].y, size);    
        Main.graphics.endFill();    

        if( minX > SCREEN_W || minY > SCREEN_H || maxX < 0 || maxY < 0 ){
            PosAry = new Array;
        }
    }  

}  


class Ball{  
    public var Pos:Point; 
    public var Spd:Point; 
    public var Radius:Number;
    public var Power:Number;
    public var BasePower:Number;


    public function Ball( p:Point, r:Number ){  
        Pos = p;
        Radius = r;
        BasePower = Power = r;
        if( g_Time < 500 ){
            BasePower += BasePower * (500-g_Time) / 500 * 0.01;
        }
        var v:Number = g_Time / 10000;
        if( v > 1.0 ) v = 1.0;
        Spd = new Point(Rand(-0.4,0.4) + v * Rand(-2.5,2.5), v * Rand(-0.1,1.0));
    }  
    
    public function update():void{
        Pos.x += Spd.x        
        Pos.y += Spd.y       
        Spd.y += 0.01; 
        Spd.x *= 0.995; 
        Spd.y *= 0.995; 
        Radius = Power;

        if( MouseData & MOUSE_LEFT ){
            var distX:Number = Main.stage.mouseX - Pos.x;
            var distY:Number = Main.stage.mouseY - Pos.y;
            var dist2:Number = distX*distX + distY*distY;
            if( dist2 < Radius*Radius){
                g_Sumi -= 15.0;
                if( MouseData & MOUSE_LEFT_TRG ) g_Sumi -= 20.0;
            }            
        }

        hitCk();


        if( Power < BasePower*0.5 ){
            g_Score++;
            for( var i:int=0; i<96; i++ ){
                var p:Point = new Point(Pos.x+Rand(-Radius, Radius), Pos.y+Rand(-Radius, Radius));
                var s:Point = new Point(p.x-Pos.x, p.y-Pos.y);
                s.x *= 0.10;
                s.y *= 0.10;
                s.x += Spd.x;
                s.y += Spd.y;
                setParticle( p, s, 1.8 );
            }
            Radius = 0;
        }
        if( Pos.y > SCREEN_H + Radius ){
            g_GameOver = true;
            Radius = 0;
        }
    }

    public function hitCkLine( line:LineList ):void{
        var radius2:Number = Radius*Radius;
        var dist2:Number;
        var distX:Number;
        var distY:Number;
        var hitCnt:int = 0;
        var i:int;
        for( i=0; i<line.PosAry.length; i+=1 ){
            distX = line.PosAry[i].x - Pos.x;
            distY = line.PosAry[i].y - Pos.y;
            dist2 = distX*distX + distY*distY;
            if( dist2 < radius2 ){
                hitCnt++;
                Spd.x *= 0.99;
                Spd.y *= 0.99;
                Spd.x -= distX*0.040;
                Spd.y -= distY*0.040;
                Power *= 0.885;
                setParticle( 
                    new Point(line.PosAry[i].x, line.PosAry[i].y), 
                    new Point( Rand(-3, 3), Math.random()-0.2 ),
                    1 );

            }
        }
        for( i=0; i<hitCnt; i+=1 ){
            line.pop();  
        }
    }

    public function hitCk():void{
        for( var lp:int=0; lp<g_LineLst.length; lp++ ){
            hitCkLine( g_LineLst[lp] );
        }
        
        if( Pos.x < Radius ){
            Pos.x = Radius;
            Spd.x *= -1;
        }
        if( Pos.x > SCREEN_W - Radius ){
            Pos.x = SCREEN_W - Radius;
            Spd.x *= -1;
        }
    }

    public function draw():void{  
        Main.graphics.lineStyle(0,0x000000);        
        Main.graphics.beginFill(0xff0000,1);    
        Main.graphics.drawCircle(Pos.x,Pos.y, Radius);    
        Main.graphics.endFill();    
    }
}


class Particle{  
    public var Pos:Point; 
    public var Spd:Point; 
    public var Radius:Number;

    public function Particle( p:Point, s:Point, r:Number ){  
        Pos = p;
        Radius = r;
        Spd = s;
    }  
    
    public function update():void{
        Pos.x += Spd.x        
        Pos.y += Spd.y       
        Spd.y += 0.03; 
        Spd.x *= 0.995; 
        Spd.x *= 0.995; 
        Radius *= 0.990;
        Radius -= 0.005;
    }

    public function draw():void{  
        Main.graphics.lineStyle(0,0x000000);        
        Main.graphics.beginFill(0xff0000,1);    
        Main.graphics.drawCircle(Pos.x,Pos.y, Radius);    
        Main.graphics.endFill();    
    }
}

var MOUSE_LEFT:int = 0x01;   
var MOUSE_LEFT_TRG:int = 0x02;   
var MouseData:int;   
function MouseCheckDown(event:MouseEvent):void{   
    MouseData |= MOUSE_LEFT;   
    MouseData |= MOUSE_LEFT_TRG;   
}            

function MouseCheckUp(event:MouseEvent):void{   
    MouseData &= ~MOUSE_LEFT;   
}            

function MouseUpdate():void{   
    MouseData &= ~MOUSE_LEFT_TRG;   
} 

function Rand( min:Number, max:Number ):Number{
    return  Math.random() * (max-min) + min;
}

