/**
 * Copyright gupon ( http://wonderfl.net/user/gupon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/krFd
 */

/*
 * rotate by mouseX / mouseY
 */
package {
	import __AS3__.vec.Vector;
	
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix3D;
	import flash.geom.PerspectiveProjection;
	import flash.geom.Utils3D;
	import flash.geom.Vector3D;
	
	[SWF(backgroundColor="#000000",frameRate="30")]
	public class ExtrudedPie extends Sprite{
		private var viewport:Shape;
		private var uvtData:Vector.<Number>;
		private var vertices:Vector.<Number>;
		private var indices:Vector.<int>;
		private var worldMatrix:Matrix3D;
		private var viewMatrix:Matrix3D;
		private var projection:PerspectiveProjection;
		private var prog:uint = 0;
		
		public function ExtrudedPie(){
			if( stage ) init();
			else addEventListener( Event.ADDED_TO_STAGE, init );
		}
		
		private function init( event:Event=null ):void{
			removeEventListener( Event.ADDED_TO_STAGE, init );
			
			//create viewport
			viewport = new Shape();
			viewport.x = stage.stageWidth / 2;
			viewport.y = stage.stageHeight / 2;
			addChild( viewport );
			
			createPieMesh( 300, 200, 270, 0, 30);
			
			worldMatrix = new Matrix3D();
			viewMatrix = new Matrix3D();
			viewMatrix.appendTranslation( 0, 0, 400 );
			projection = new PerspectiveProjection();
			projection.fieldOfView = 60;
			
			addEventListener( Event.ENTER_FRAME, enterFrame );
		}
		
		private function enterFrame( event:Event ):void{
			update();
			render();
		}
		
		private function update():void{
			prog+=5;
			createPieMesh( 300, 200, Math.cos(prog%360*Math.PI/180)*120+180);
			worldMatrix.appendRotation( viewport.mouseX/100, Vector3D.Y_AXIS );
			worldMatrix.appendRotation( viewport.mouseY/100, Vector3D.X_AXIS );
		}
		
		private function render():void{
			var m:Matrix3D = new Matrix3D();
			m.append( worldMatrix );
			m.append( viewMatrix );
			m.append( projection.toMatrix3D() );
			
			var projected:Vector.<Number> = new Vector.<Number>();
			Utils3D.projectVectors( m, vertices, projected, uvtData );
			
			viewport.graphics.clear();
			viewport.graphics.lineStyle( 1, 0xFF0000 );
			viewport.graphics.drawTriangles( projected, indices );
		}
		
		public function createPieMesh(radius:Number, innerRadius:Number=0, degree:Number = 60, offsetDegree:Number=0, division:uint=10):void{
			indices = new Vector.<int>(division*2*3*2);
			vertices = new Vector.<Number>((division+1)*2*3*2,true);
			uvtData = new Vector.<Number>((division+1)*2*2*2);
			
			if(degree > 0){
				var i:int;
				for( i=0;i<=division*2*3*2;i+=12 ){
					var radians:Number = degree / division * Math.PI / 180 * i / 12;
					var cos:Number = Math.cos( radians );
					var sin:Number = Math.sin( radians );
					//1
					vertices[i  ] = cos * radius;
					vertices[i+1] = sin * radius;
					vertices[i+2] = -50;
					//2
					vertices[i+3] = cos * innerRadius;
					vertices[i+4] = sin * innerRadius;
					vertices[i+5] = -50;
					//3
					vertices[i+6] =  vertices[i  ];
					vertices[i+7] =  vertices[i+1];
					vertices[i+8] =  50;
					//4
					vertices[i+9] =  vertices[i+3];
					vertices[i+10] = vertices[i+4];
					vertices[i+11] = 50;
					uvtData.push(0,0);
				}
				for( i=0;i<division*4;i++ ){
					var t:int = i * 24;
					//1
					indices[t  ] = i * 4 + 1;
					indices[t+1] = i * 4 + 5;
					indices[t+2] = i * 4 + 0;
					//2
					indices[t+3] = i * 4 + 0;
					indices[t+4] = i * 4 + 5;
					indices[t+5] = i * 4 + 4;
					//3
					indices[t+6] =  i * 4 + 7;
					indices[t+7] =  i * 4 + 3;
					indices[t+8] =  i * 4 + 2;
					//4
					indices[t+9] =  i * 4 + 7;
					indices[t+10] = i * 4 + 2;
					indices[t+11] = i * 4 + 6;
					//5
					indices[t+12] = i * 4 + 0;
					indices[t+13] = i * 4 + 4;
					indices[t+14] = i * 4 + 2;
					//6
					indices[t+15] = i * 4 + 2;
					indices[t+16] = i * 4 + 4;
					indices[t+17] = i * 4 + 6;
					//7
					indices[t+18] = i * 4 + 5;
					indices[t+19] = i * 4 + 1;
					indices[t+20] = i * 4 + 3;
					//8
					indices[t+21] = i * 4 + 5; 
					indices[t+22] = i * 4 + 3;
					indices[t+23] = i * 4 + 7;
				}
			}
		}
	}
}