/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kr23
 */

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
        
        private var bitmapData:BitmapData;
        private var bitmap:Bitmap;
        
        private var cx:Number = 0;
        private var cy:Number = 0;
        private var px:Number = 0;
        private var py:Number = 0;
        private var vx:Number = cx - px;
        private var vy:Number = cy - py;
        
        private var lx:Number = 0;
        private var ly:Number = 0;
        
        private var sx:Number = 1;
        private var sy:Number = 1;
        
        private var i:Number = 0;
        private var j:Number = 0;

        private var dx:Number = 0;
        private var dy:Number = 0;
        private var e:Number = 0;
        
        private var points:Vector.<Point>;
        
        public function FlashTest() {
            // write as3 code here..
            
            points = new Vector.<Point>();
            
            bitmapData = new BitmapData(465,465);
            bitmap = new Bitmap(bitmapData);
            
            addChild(bitmap);
            
            addEventListener(Event.ENTER_FRAME, loop);
            
        }
        
        private function loop(event:Event):void
        {
            //attach new c
            cx = stage.mouseX;
            cy = stage.mouseY;
            
            //calculate v
            vx = cx - px;
            vy = cy - py;
            
            //calculate l
            lx = Math.abs(vx);
            ly = Math.abs(vy);  
            
            //set sign
            sx = (lx != 0) ? vx / lx : 1;
            sy = (ly != 0) ? vy / ly : 1;
            
            //make Vector
            i = 0;
            j = 0;
            
            dx = 2 * lx;
            dy = 2 * ly;
            
            points = new Vector.<Point>();
            
            if(lx >= ly)
            {
                e = lx;
                
                for(i; i <= lx; i++)
                {
                    points.push(new Point(sx * i, sy * j));
                    e += dy;
                    if(e >= dx)
                    {
                        j++;
                        e = e - dx;
                    }
                }
                
            }
            else
            {
                e = ly;
                
                for(i; i <= ly; i++)
                {
                    points.push(new Point(sx * j, sy * i));
                    e += dx;
                    if(e >= dy)
                    {
                        j++;
                        e = e - dy;
                    }
                }
            }
            
            
            
            
            //Draw
            bitmapData.lock()
            
            points.forEach(function(item:Point, index:int, vector:Vector.<Point>):void{
                bitmapData.setPixel(px + item.x, py + item.y, 0x000000);
            });
            
            bitmapData.setPixel(cx, cy, 0xFF0000);
            
            bitmapData.unlock();
            
            //save c to p
            px = cx;
            py = cy;
        }
    }
}