/**
 * Copyright yasai ( http://wonderfl.net/user/yasai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kqvF
 */

package 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	
	public class RandomText extends MovieClip 
	{
		private const SORCE_TXT:String = "_/-=+%&$#!?ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
		private const HELLO_WORLD:String = "HELLO WORLD";
		
		private var textFld:TextField;
		private var enterFrameCount:int = 0;
		private var playTime:int = 20;
		
		public function RandomText() {
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			textFld = new TextField();
			addChild(textFld); 
			textFld.text = "";
			textFld.type = TextFieldType.DYNAMIC;
			textFld.selectable = false;
			textFld.x = 200;
			textFld.y = 150;
			textFld.height = 20;
			textFld.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHandler);
			textFld.dispatchEvent(new MouseEvent(MouseEvent.MOUSE_OVER));
		}
		
		private function mouseOverHandler(e:MouseEvent):void {
			textFld.text = "";
			enterFrameCount = 0;
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function enterFrameHandler(e:Event):void {
			++enterFrameCount;
			var r_txt:String = "";
			for (var i:int = 0; i < HELLO_WORLD.length; i++) {
				if (enterFrameCount - playTime < i) {
					r_txt = r_txt + SORCE_TXT.charAt(Math.floor(Math.random() * SORCE_TXT.length));
					continue;
				}
				r_txt = r_txt + HELLO_WORLD.charAt(i);
			}
			textFld.text = r_txt;
			if (textFld.text == HELLO_WORLD) {
				removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
			}
		}
	}
	
}