/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kqYM
 */


// forked from quqjp's Tiling
package 
{
    /*
    * BitmapをやめてShapeにしてみた。
    * 構造理解のため、そぎ落とせるところはそぎ落としている。
    *
    * ※ 止まりません。
    */

    import com.bit101.components.PushButton;
    import flash.display.*;
    import flash.events.Event;
    
    public class TilingOriginal extends Sprite
    {
        static public const TILE_SCALE:uint = 10;;
        static public const STATE_AUTOMATIC:String = "stateAutomatic";
        static public const STATE_MANUAL:String = "stateManual";
        private var mapLogic:MapLogic;
        private var tileAmount:int=45;
        private var epSprite:Sprite;
        private var state:String;
        static private var debugger:Debugger;
        private var fsSprite:Sprite;
        
        public function TilingOriginal():void
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var sCKeyBoard:SCKeyBoard = new SCKeyBoard(stage);
            sCKeyBoard.keyAndFunction =
            {
                Z:doStep
            }
            debugger = new Debugger(this);
            mapLogic = new MapLogic( tileAmount, tileAmount, 10, TILE_SCALE );
            mapLogic.iSignal.add(emptyPosDraw);
            mapLogic.filledSpaceSignal.add(filledSpaceDraw);
            new PushButton(this, 0, 445, 'stop', doStop);
            new PushButton(this, 100, 445, 'play', doPlay);
            epSprite = Sprite(addChild(new Sprite));
            fsSprite = Sprite(addChild(new Sprite));
            state = STATE_MANUAL;
            init();
        }
        
        private function filledSpaceDraw(filledSpaceIndex:int):void 
        {
            var g:Graphics = fsSprite.graphics;
            g.beginFill(0);
            drawRectangleAt(g, filledSpaceIndex,5);
            g.endFill();
            swapChildren(fsSprite, getChildAt(numChildren - 1));
        }
        
        static public function traceIt(msg:String):void 
        {
            debugger.traceThis(msg)
            
        }
        
        private function init():void 
        {
            switch (state) 
            {
                case STATE_AUTOMATIC:
                    addEventListener( Event.ENTER_FRAME, render );
                break;
                case STATE_MANUAL:
                    new PushButton(this, 200, 445, 'step', doStep);
                break;
                default:
                
                break;
            }
        }
        
        private function doStep(e:Event=null):void 
        {
            render(null);
        }
        
        private function emptyPosDraw(emptyPos:int):void 
        {
            var g:Graphics = epSprite.graphics;
            g.beginFill(0x00ff33);
            g.lineStyle(0);
            drawRectangleAt(g, emptyPos,4,4);
            g.endFill();
            swapChildren(epSprite, getChildAt(numChildren - 1));
        }
        
        private function doPlay(e:Event):void 
        {
            addEventListener( Event.ENTER_FRAME, render );
        }
        
        private function doStop(e:Event):void 
        {
            removeEventListener( Event.ENTER_FRAME, render );
        }
        
        private function render( e:Event ):void
        {
            addChild( mapLogic.create() );
        }
        private function drawRectangleAt(g:Graphics, i:int, size:Number,xoff:Number=0,yoff:Number=0):void 
        {
            g.drawRect(
                i % tileAmount * TILE_SCALE + 1+xoff,
                uint(i / tileAmount) * TILE_SCALE + 1+yoff, 
                size, 
                size
            );
        }
    }
}

import com.bit101.components.PushButton;
import com.bit101.components.TextArea;
import com.bit101.components.VBox;
import flash.display.*;
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.text.TextField;
import flash.ui.Keyboard;
import idv.cjcat.signals.ISignal;
import idv.cjcat.signals.Signal;
    
internal class MapLogic
{
    private var _map            :Array = [];
    private var gridW        :int;
    private var gridH        :int;
    private var tileMax        :int;
    private var tileScale    :int = 10;
    public  var emptyPos        :int = 0;
    private var py:int;
    private var oldPy:int;
    public var filledSpaceSignal:ISignal;
    public var iSignal:ISignal;
    
    public function MapLogic( gridW:int, gridH:int, tileMax:int, tileScale:int ):void
    {
        this.gridW        = gridH;
        this.gridH        = gridW;
        this.tileMax        = tileMax;
        this.tileScale    = tileScale;
        iSignal = new Signal(int);
        filledSpaceSignal = new Signal(int);
    }
    
    public function create():Tile
    {
        var position        :int = -1;
        var emptyWidth    :int = 0;
        var conditionId:int;
        for ( var i:int = emptyPos; i < emptyPos + 500 ; i++ )
        {
            cTrace( "i : " + i );
            if ( !_map[i] && position == -1 )
            {
                cTrace("---------1--------------");
                cTrace( "position == -1 : " + (position == -1) +", !_map[i] : " + (!_map[i]) );
                position = i;
                emptyWidth++;
                conditionId = 1;
            } else if ( emptyWidth >= tileMax )
            {
                cTrace("---------2--------------");
                cTrace( "( emptyWidth >= tileMax ) : " + ( emptyWidth >= tileMax ) );
                conditionId = 2;
                break;
            } else if ( !_map[i] &&
            !( i % gridW == 0 && i != emptyPos ) ) 
            {
                cTrace("---------3--------------");
                cTrace( "!_map[i] : " + (!_map[i]) +", i != emptyPos : " + (i != emptyPos) +", i % gridW == 0 : " + (i % gridW == 0) );
                conditionId = 3;
                emptyWidth++;
            } else if ( position != -1 ) 
            {
                cTrace("---------4--------------");
                cTrace( "( position != -1 ) : " + ( position != -1 ) );
                conditionId = 4;
                break;
            }
            if (conditionId == 0) 
            {
                filledSpaceSignal.dispatch(i);
            }
        }
        var ww:int    = int( Math.random() * emptyWidth )+1;
        
        var p:int = position;
        for ( var yy:int = 0; yy < ww; yy++ ){
            for ( var xx:int = 0; xx < ww; xx++ ){
                _map[p] = 1;
                p++;
            }
            p += gridW - ww;
        }
        emptyPos = position + ww;
        iSignal.dispatch(emptyPos);
        var px:int = position % gridW * tileScale;
        py = position == 0 ? 0 : int( position / gridW ) * tileScale;
        var tile:Tile = new Tile( px, py, ww * tileScale, ww * tileScale );    
        if (py!=oldPy) 
        {
            tile.graphics.beginFill(0xff0000);
            tile.graphics.drawRect(0, 0, 8, 8);
            tile.graphics.endFill();
        }
        oldPy = py;
        switch (conditionId) 
        {
            case 0:
                tile.graphics.beginFill(0xff0000)
                
            break;
            case 1:
                tile.graphics.beginFill(0xff00ff)
                
            break;
            case 2:
                tile.graphics.beginFill(0xffff00)
                //tile.graphics.lineStyle(0);
            break;
            case 3:
                tile.graphics.beginFill(0x00ff00)
                
            break;
            case 4:
                tile.graphics.beginFill(0x0088ff)
                
            break;
        }
        tile.graphics.drawRect(0, 0, 4, 4);
        tile.graphics.endFill();
        return tile;
    }
    
    private function cTrace(arg1:String):void 
    {
        TilingOriginal.traceIt(arg1);
    }
}

internal class Tile extends Shape
{
    public function Tile( _x:int, _y:int, _w:int, _h:int ):void
    {
        this.x = _x;
        this.y = _y;
        
        graphics.lineStyle( 1, 0x000000 );
        //graphics.beginFill(0xffffff);
        graphics.drawRect( 0, 0, _w, _h );
    }
}
class Debugger extends VBox
{
    private var _textField:TextField;
    private var _msprite:Sprite;
    public function Debugger(msprite:Sprite) 
    {
        super();
        _msprite = msprite;
        _msprite.addChild(this);
        addChildAt(new PushButton(null, 0, 0, "clear", doClear), numChildren);;
        var textArea:TextArea = new TextArea();
        addChildAt(textArea, numChildren);
        _textField = textArea.textField
        x = 465;
        stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDownHandler);
        textArea.setSize(465, 415);
        var sCKeyBoard:SCKeyBoard = new SCKeyBoard(stage);
        sCKeyBoard.keyAndFunction =
        {
            Q:setDebuggerVisibility,
            A:setDebuggerAlpha,
            C:clear
        }
    }
    
    private function clear():void 
    {
        _textField.text = "";
    }
    private function setDebuggerAlpha():void 
    {
        const debuggerAlpha:Number = 0.5;
        alpha = alpha == debuggerAlpha?1:debuggerAlpha;
    }
    
    private function setDebuggerVisibility():void 
    {
        visible = !visible;
    }
    
    private function onKeyDownHandler(e:KeyboardEvent):void 
    {
        switch (e.keyCode) 
        {
            case Keyboard.UP:
                _textField.scrollV -= 10;
            break;
            case Keyboard.DOWN:
                _textField.scrollV += 10;
            break;
            default:
                
            break;
        }
    }
    
    private function doClear(e:Event):void 
    {
        _textField.text = "";
    }
    
    public function get textField():TextField 
    {
        return _textField;
    }
    
    public function set textField(value:TextField):void 
    {
        _textField = value;
    }
    
    public function traceThis(msg:String):void 
    {
        _textField.appendText(msg + "\n");
        _textField.scrollV = textField.maxScrollV;
        
    }
}
class SCKeyBoard
{
    private var _stage:Stage;
    private var object:Object;
    public var keyAndFunction:Object;
    public function SCKeyBoard(stageArg:Stage) 
    {
        _stage = stageArg;
        _stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
    }
    
    private function keyDownHandler(e:KeyboardEvent):void 
    {
        if (!keyAndFunction) 
        {
            throw new Error("keyAndFunction should be defined");
        }
        var callBack:Function;
        if (keyAndFunction[String.fromCharCode(e.keyCode)]) 
        {
            callBack = keyAndFunction[String.fromCharCode(e.keyCode)]
            callBack();
        }
        return;
    }
    
    private function cTrace(arg1:String):void 
    {
        TilingOriginal.traceIt(arg1);
    }
    
}


