/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kqMk
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
 
	public class Main extends Sprite
	{
		private var bd:BitmapData;
		private var image:BitmapData;
		private var count:int = 0;
		private const WIDTH:int = 16;
		private const HEIGHT:int = 24;
 
		public function Main()
		{
			graphics.beginFill(0x0);
			graphics.drawRect(0, 0, 465, 465);
			graphics.endFill();
 
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
			loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/c/c3/c3bd/c3bdd35be58ffff42467612d0a6dfb28749065d3"), new LoaderContext(true));
		}
 
		private function initHandler(event:Event):void
		{
			var loader:Loader = event.currentTarget.loader;
			image = new BitmapData(loader.width, loader.height, true, 0x0);
			image.draw(loader);
 
			bd = new BitmapData(300, loader.height, true, 0x0);
			addChild(new Bitmap(bd));
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			var value:int = count++;
			var width:int = (value.toString().length - 1) * WIDTH;
			var tx:int = 0;
 
			while (value)
			{
				bd.copyPixels(image, new Rectangle(value % 10 * WIDTH, 0, WIDTH, HEIGHT), new Point(width - tx * WIDTH, 0));
				value /= 10;
				tx++;
			}
		}
	}
}
