/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/koqU
 */

// forked from fakestar0826's BounceInTheBox
package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var balls:Array;
        private var numBalls:int = 50;
        private var fl:Number = 250;
        private var vpX:Number = stage.stageWidth / 2;
        private var vpY:Number = stage.stageHeight / 2;
        private var top:Number = -100;
        private var bottom:Number = 100;
        private var left:Number = -100;
        private var right:Number = 100;
        private var front:Number = 100;
        private var back:Number = -100;
        
        public function FlashTest() {
            // write as3 code here..
            balls = [];
            for(var i:int = 0;i < numBalls;i++)
            {
                var b:Ball3D = new Ball3D(15);
                balls[i] = b;
                b.xpos = Math.random() * 200 - 100;
                b.ypos = Math.random() * 200 - 100;
                b.zpos = Math.random() * 200 - 100;
                addChild(b);
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            var angleY:Number = (mouseX - vpX) * 0.001;
            for(var i:int = 0;i < numBalls;i++)
            {
                var b:Ball3D = balls[i];
                rotate(b, angleY);
            }
        }
        
        private function rotate(b:Ball3D, angleY:Number):void
        {
            var cosY:Number = Math.cos(angleY);
            var sinY:Number = Math.sin(angleY);
            
            var x1:Number = b.xpos * cosY - b.zpos * sinY;
            var z1:Number = b.zpos * cosY + b.xpos * sinY;
            
            b.xpos = x1;
            b.zpos = z1;
            
            if(b.zpos > -fl)
            {
                var scale:Number = fl / (fl + b.zpos);
                b.scaleX = b.scaleY = scale;
                b.x = vpX + b.xpos * scale;
                b.y = vpY + b.ypos * scale;
                b.visible  = true;
            }
            else
            {
                b.visible = false;
            }
        }

    }
}
import flash.display.Sprite;

class Ball3D extends Sprite
{
    public var r:Number;
    public var xpos:Number = 0;
    public var ypos:Number = 0;
    public var zpos:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var vz:Number = 0;
    public var mass:Number = 1;
    
    public function Ball3D(r:Number = 40, c:uint = 0xFF0000)
    {
        this.r = r;
        graphics.beginFill(c);
        graphics.drawCircle(0, 0, r);
        graphics.endFill();
    }

}
