/**
 * Copyright ohm924 ( http://wonderfl.net/user/ohm924 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kobk
 */

package



{



    import flash.display.Bitmap;



    import flash.display.BitmapData;



    import flash.display.Sprite;



    import flash.events.Event;



    import flash.events.MouseEvent;



    import flash.geom.Point;



    import flash.geom.Rectangle;



    import flash.system.System;



    import frocessing.color.ColorHSL;



    import frocessing.color.ColorLerp;



    import com.bit101.components.*;



    



    public class Main extends Sprite



    {



        private var window:Panel;

        



        private var bitmapA:Bitmap;



        private var bitmapB:Bitmap;



        private var bd:BitmapData;



        private var bdB:BitmapData;



        private var canvas:Sprite;



        private var canvasB:Sprite;



        



        private var r:InputText;



        private var g:InputText;



        private var b:InputText;



        



        private var h:InputText;



        private var s:InputText;



        private var l:InputText;



        



        private var c:ColorChooser;



        



        private var arrow:Sprite;



        private var select:Sprite;



        



        private var cbd:BitmapData;



        private var t:String = "";



        



        public function Main()



        {



            window = new Panel(this, 0, 0);



            window.width = window.height = 465;



            



            bd = new BitmapData(360, 360, false);



            var color:ColorHSL = new ColorHSL();



            



            for (var y:int = 0; y < bd.height; y++)



            {



                color.s = 1.0 - (y / bd.height)



                for (var x:int = 0; x < bd.width; x++)



                {



                    color.h = 360 * (x / bd.width);



                    bd.setPixel(x, y, color.value);



                }



            }



            



            bdB = new BitmapData(50, 360, false);



            



            canvas = new Sprite();



            canvas.graphics.beginFill(0xF3F3F3);



            canvas.graphics.drawRect(0, 0, 380, 380);



            canvas.graphics.endFill();



            



            window.content.addChild(canvas);



            canvas.x = 0;



            canvas.y = 0;



            



            bitmapA = new Bitmap(bd);



            bitmapA.x = bitmapA.y = 20;



            canvas.addChild(bitmapA);



            canvas.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);



            canvas.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);



            



            canvasB = new Sprite();



            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown2);



            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp2);



            canvasB.x = 400;



            canvasB.y = 20;



            canvasB.graphics.beginFill(0x0, 0);



            canvasB.graphics.drawRect(0, 0, 465 - canvasB.x, bd.height + 20);



            canvasB.graphics.endFill();



            window.content.addChild(canvasB);



            



            bitmapB = new Bitmap(bdB);



            canvasB.addChild(bitmapB);



            



            r = new InputText(window.content, 30, 397, "255", rgbHandler);



            g = new InputText(window.content, 30, 417, "0", rgbHandler);



            b = new InputText(window.content, 30, 437, "0", rgbHandler);



            r.name = "r", g.name = "g", b.name = "b";



            



            h = new InputText(window.content, 105, 397, "0", hslHandler);



            s = new InputText(window.content, 105, 417, "1.00", hslHandler);



            l = new InputText(window.content, 105, 437, "1.00", hslHandler);



            h.name = "h", s.name = "s", l.name = "l";



            



            c = new ColorChooser(window.content, 180, 397, 0xFF0000, chooserHandler);



            



            var rtext:Label = new Label(window.content, 15, 397, "R");



            var gtext:Label = new Label(window.content, 15, 417, "G");



            var btext:Label = new Label(window.content, 15, 437, "B");



            



            var htext:Label = new Label(window.content, 90, 397, "H");



            var stext:Label = new Label(window.content, 90, 417, "S");



            var ltext:Label = new Label(window.content, 90, 437, "L");



            



            r.maxChars = g.maxChars = b.maxChars = h.maxChars = 3;



            s.maxChars = l.maxChars = 4;



            r.width = g.width = b.width = h.width = s.width = l.width = 30;



            



            select = new Sprite();



            select.graphics.lineStyle(3.0, 0x0);



            select.graphics.beginFill(0x0, 0);



            select.graphics.drawCircle(0, 0, 10);



            select.graphics.endFill();



            canvas.addChild(select);







            arrow = new Sprite();



            arrow.graphics.beginFill(0x393939);



            arrow.graphics.lineTo(10, -10);



            arrow.graphics.lineTo(10,  10);



            arrow.graphics.endFill();



            arrow.x = bdB.width;



            arrow.y = bdB.height / 2;



            canvasB.addChild(arrow);



            



            cbd = new BitmapData(130, 40, false, 0xFF0000);



            var bitmap:Bitmap = new Bitmap(cbd);



            bitmap.x = c.x;



            bitmap.y = c.y + c.height + 5;



            window.content.addChild(bitmap);



            



            var buttonA:PushButton = new PushButton(window.content, 330, 397, "Color - Copy to Clipboard", copyHandlerA);



            var buttonB:PushButton = new PushButton(window.content, 330, 417, "  RGB - Copy to Clipboard", copyHandlerB);



            var buttonC:PushButton = new PushButton(window.content, 330, 437, "  HSL - Copy to Clipboard", copyHandlerC);



            



            buttonA.width = buttonB.width = buttonC.width = 130;



            



            createColorLerp(bd.getPixel(0, 0));



        }



        



        private function chooserHandler(event:Event):void



        {



            t = "c";



            createColorLerp(c.value);



        }



        



        private function copyHandlerA(event:Event = null):void



        {



            System.setClipboard("0x" + c.value.toString(16).toUpperCase());



        }



        



        private function copyHandlerB(event:Event = null):void



        {



            var color:ColorHSL = new ColorHSL();



            color.value = c.value;



            



            System.setClipboard(color.r + ", " + color.g + ", " + color.b);



        }



        



        private function copyHandlerC(event:Event = null):void



        {



            var color:ColorHSL = new ColorHSL();



            color.value = c.value;



            



            System.setClipboard(int(color.h) + ", " + color.s.toFixed(2) + ", " + color.l.toFixed(2));



        }



        



        private function rgbHandler(event:Event = null):void



        {



            var color:ColorHSL = new ColorHSL();



            color.r = int(r.text);



            color.g = int(g.text);



            color.b = int(b.text);



            



            t = event.currentTarget.name;



            



            createColorLerp(color.value);



        }



        



        private function hslHandler(event:Event = null):void



        {



            var color:ColorHSL = new ColorHSL();



            color.h = int(h.text);



            color.s = Number(s.text);



            color.l = Number(l.text);



            



            t = event.currentTarget.name;



            



            createColorLerp(color.value);



        }



        



        private function onMouseDown(event:MouseEvent):void



        {



            t = "";



            onMouseMove();



            canvas.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);



        }



        



        private function onMouseUp(event:MouseEvent = null):void



        {



            canvas.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);



        }



        



        private function onMouseMove(event:MouseEvent = null):void



        {



            var point:Point = bitmapA.globalToLocal(new Point(mouseX, mouseY));



            if (point.x < 0) point.x = 0;



            if (point.y < 0) point.y = 0;



            if (bd.width <= point.x) point.x = bd.width - 1;



            if (bd.height <= point.y) point.y = bd.height - 1;



            



            var color:ColorHSL = new ColorHSL();



            color.value = bd.getPixel(point.x, point.y);



            



            createColorLerp(color.value);



            



            var colorB:ColorHSL = new ColorHSL();



            var pointB:Point = bitmapB.globalToLocal(new Point(0, arrow.y + canvasB.y));



            



            if (pointB.y < 0) pointB.y = 0;



            colorB.value = bdB.getPixel(0, pointB.y);



            color.l = colorB.l;



            



            var p:Point = bitmapA.localToGlobal(point);



            select.x = p.x;



            select.y = p.y;



            



            if (t != "c") c.value = color.value;



            cbd.fillRect(cbd.rect, color.value);



            



            if (t != "r") r.text = color.r.toString();



            if (t != "g") g.text = color.g.toString();



            if (t != "b") b.text = color.b.toString();



            



            if (t != "h") h.text = int(color.h).toString();



            if (t != "s") s.text = color.s.toFixed(2).toString();



            if (t != "l") l.text = color.l.toFixed(2).toString();



            



            if (event != null) event.updateAfterEvent();



        }



        



        private function onMouseDown2(event:MouseEvent):void



        {



            if (mouseX < canvasB.x) return;



            if (mouseY >= h.y) return;



            



            t = "";



            onMouseMove2();



            canvasB.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove2);



        }



        



        private function onMouseUp2(event:MouseEvent = null):void



        {



            canvasB.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove2);



        }



        



        private function onMouseMove2(event:MouseEvent = null):void



        {



            var point:Point = bitmapB.globalToLocal(new Point(mouseX, mouseY));



            if (point.x < 0) point.x = 0;



            if (point.y <= 0)



            {



                canvasB.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove2);



                point.y = 0;



            }



            if (bdB.width <= point.x) point.x = bd.width - 1;



            if (bdB.height <= point.y) point.y = bd.height - 1;



            



            point.x = 0;



            arrow.y = point.y;



            



            var color:ColorHSL = new ColorHSL();



            color.value = bdB.getPixel(point.x, point.y);



            



            if (t != "c") c.value = color.value;



            cbd.fillRect(cbd.rect, color.value);



            



            if (t != "r") r.text = color.r.toString();



            if (t != "g") g.text = color.g.toString();



            if (t != "b") b.text = color.b.toString();



            



            if (t != "h") h.text = int(color.h).toString();



            if (t != "s") s.text = color.s.toFixed(2).toString();



            if (t != "l") l.text = color.l.toFixed(2).toString();



            



            if (event != null) event.updateAfterEvent();



        }



        



        private function createColorLerp(color:int):void



        {



            var lerpA:Array = ColorLerp.gradient(0xFFFFFF, color, bd.height / 2);



            var lerpB:Array = ColorLerp.gradient(color, 0x0, bd.height / 2);



            



            for (var y:int = 0; y < lerpA.length; y++)



            {



                bdB.fillRect(new Rectangle(0, y, bdB.width, 1), lerpA[y]);



                bdB.fillRect(new Rectangle(0, y - 1 + bdB.height / 2, bdB.width, 1), lerpB[y]);



            }



            



            var hsl:ColorHSL = new ColorHSL();



            hsl.value = color;



            



            var point:Point = bitmapA.localToGlobal(new Point(hsl.h / 360 * bd.width, (1.0 - hsl.s) * bd.height));



            select.x = point.x;



            select.y = point.y;



            



            if (t != "r") r.text = hsl.r.toString();



            if (t != "g") g.text = hsl.g.toString();



            if (t != "b") b.text = hsl.b.toString();



            



            if (t != "h") h.text = int(hsl.h).toString();



            if (t != "s") s.text = hsl.s.toFixed(2).toString();



            if (t != "l") l.text = hsl.l.toFixed(2).toString();



            



            if (t != "c") c.value = hsl.value;



            cbd.fillRect(cbd.rect, hsl.value);



        }



    }



}