/**
 * Copyright earl223 ( http://wonderfl.net/user/earl223 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/koZk
 */

// forked from xoul's Particle
package
{
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.ColorTransform;
    import flash.display.Shape;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.display.Sprite;
    
    public class Main extends Sprite
    {
        
        private const NUM_PARTICLES : int = 5000;
        //private const SPEED : Number = Math.random()*.5;
        private const MAX_POWER : Number = 100;
        
        private var _canvas : BitmapData;  
        private var _pixels : Vector.<Object>;
        
        private var _alphaTransform : ColorTransform;
        private var _blurFilter : BlurFilter;
        
        private var _zeroPoint : Point;

        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0 );
            addChild( new Bitmap( _canvas ) );
            
            _pixels = new Vector.<Object>( NUM_PARTICLES, true );
            
            for( var i : int = 0; i < NUM_PARTICLES; ++i )
            {
                var pixel : Object = {};
                pixel.x = Math.random() * stage.stageWidth;
                pixel.y = Math.random() * stage.stageHeight;
                pixel.speed = Math.random() * .1 + .01;
                pixel.dx = 0;
                pixel.dy = 0;
                pixel.lastX = pixel.x;
                pixel.lastY = pixel.y;
                pixel.color = Math.random() *  0xFFFFFF;
                _pixels[i] = pixel;
            }
            
            _alphaTransform = new ColorTransform( 1, 1, 1, .9 );
            _blurFilter = new BlurFilter;
            _zeroPoint = new Point;
            
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
 
        }
        
        private function onEnterFrame( e : Event ) : void
        {
            _canvas.lock();
            _canvas.applyFilter( _canvas, _canvas.rect, _zeroPoint, _blurFilter );
            _canvas.colorTransform( _canvas.rect, _alphaTransform );
            
            var pixel : Object;
            var angle: Number;
            for( var i : int = 0; i < NUM_PARTICLES; ++i )
            {
                pixel = _pixels[i];
                
                pixel.lastX = pixel.x;
                pixel.lastY = pixel.y;
                
                if (i == 0) angle = Math.atan2( pixel.y - mouseY, pixel.x - mouseX );
                else angle = Math.atan2( pixel.y - _pixels[0].y, pixel.x - _pixels[0].x );
                pixel.dx -= pixel.speed * Math.cos( angle );
                pixel.dy -= pixel.speed * Math.sin( angle );
                
                if (pixel.dx > 2) pixel.dx = 2;
                if (pixel.dx < -2) pixel.dx = -2;
                if (pixel.dy > 2) pixel.dy = 2;
                if (pixel.fy < -2) pixel.dy = -2;
                
                pixel.x += pixel.dx;
                pixel.y += pixel.dy;
                
                //pixel.dx *= .9;
                //pixel.dy *= .9;
                
                drawLine( pixel.lastX, pixel.lastY, pixel.x, pixel.y, pixel.color );
            }
            
            //canvas.applyFilter( canvas, canvas.rect, new Point, blurFilter );
            
            _canvas.unlock();
        }
        
      
        
        private function drawLine( startX : Number, startY : Number, endX : Number, endY : Number, color : Number ) : void
        {
            var dx : Number = endX - startX;
            var dy : Number = endY - startY;
            var a : Number;
            var b : Number;
            var tmp : Number;
            var len : Number;
            var i : int;
            
            if( getAbs( dx ) > getAbs( dy ) )
            {
                a = dy / dx;
                b = startY;
                
                if( startX > endX )
                {
                    tmp = startX;
                    startX = endX;
                    endX = tmp;
                    b = endY;
                }
                
                len = endX - startX;
                for( i = 0; i < len; ++i )
                {
                    _canvas.setPixel( i + startX, i * a + b, color );
                }
            }
            else
            {
                a = dx / dy;
                b = startX;
                
                if( startY > endY )
                {
                    tmp = startY;
                    startY = endY;
                    endY = tmp;
                    b = endX;
                }
                
                len = endY - startY;
                for( i = 0; i < len; ++i )
                {
                    _canvas.setPixel( i * a + b, i + startY, color );
                }
            }
        }
        
        private function getAbs( x : Number ) : Number
        {
            return x < 0 ? -x : x;
        }
    }
}