/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/knEg
 */

// forked from tepe's 検索窓
package {
    import flash.text.*;
    import flash.display.*;
    import flash.events.*;
    public class FlashTest extends Sprite {
        private var sBar:SearchBar;
        private var tf:TextField;
        public function FlashTest() {
            tf = new TextField();
            addChild(tf);
            tf.height=400;
            tf.text = "test\n";
            sBar = new SearchBar();
            addChild(sBar);
            sBar.x = 150;
            sBar.y = 150;
            sBar.text = "search";


            sBar.btn.addEventListener(MouseEvent.CLICK,onClick);

        }
        private function onClick(e:MouseEvent):void{
            tf.appendText(sBar.text+"\n");
            tf.scrollV = tf.maxScrollV;
        }

    }
}

///////////////////////////////////////////////////
// SearchBar
///////////////////////////////////////////////////
import flash.display.*;
import flash.text.*;
import flash.events.*;
import flash.geom.*;

class SearchBar extends Sprite{
    private var input:TextField;
    private var icon:SearchIcon = new SearchIcon();
    private var color1:uint = 0x000000;
    private var color2:uint = 0xaaaaaa;
    private var color3:uint = 0x0088ff;
    public var btn:Sprite;
    public function SearchBar():void{
        
        var a:Shape = createGradientHole(120,13);
        addChild(a);
        
        input = new TextField();
        input.type ="input";
        input.y =-10;
        input.addEventListener(Event.CHANGE,onChange);
        input.addEventListener(KeyboardEvent.KEY_DOWN,pressKey);
        input.addEventListener(KeyboardEvent.KEY_UP,releaseKey);
        addChild(input);
        
        btn = new Sprite();
        btn.addChild(icon);
        icon.x = -2;
        btn.graphics.beginFill(0,0);
        btn.graphics.drawRect(-12,-10,24,20);
        btn.graphics.endFill();
        btn.x = 120;
        btn.buttonMode = true;
        btn.addEventListener(MouseEvent.MOUSE_OVER,rollOver);
        btn.addEventListener(MouseEvent.MOUSE_OUT,rollOut);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,press);
        btn.addEventListener(MouseEvent.MOUSE_UP,release);
        addChild(btn);
        
        
        rollOut();
    }
    
    
    public function set text(str:String):void{
        input.text = str;
        onChange();
    }
    public function get text():String{
        return input.text;
    }
    
    private function createGradientHole(w:uint, c:Number):Shape{
        var target:Shape = new Shape();
        var colors:Array = [0x0033aa, 0x00aaff];
        var alphas:Array = [0.4, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w+c*2, c*2, 0.5*Math.PI, -c, -c);
        target.graphics.beginFill(0xffffff);
        target.graphics.drawRoundRect(-c, -c, w+c*2, c*2, c*2);
        target.graphics.endFill();
        target.graphics.lineStyle(2,0x555555,0.9);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-c, -c, w+c*2, c*2, c*2);
        target.graphics.endFill();
        return target;
    }
    
    private function onChange(e:Event=null):void{
        var overColorTrans:ColorTransform = new ColorTransform();
        if(input.text.length==0)overColorTrans.color = color2;
        
        else overColorTrans.color = color1;
        icon.transform.colorTransform = overColorTrans;
    }
    private function pressKey(e:KeyboardEvent):void{
        if(e.keyCode==13 && 0<input.text.length){ 
            press();
            var ev:MouseEvent = new MouseEvent(MouseEvent.CLICK);
            btn.dispatchEvent(ev);
        }
    }
    private function releaseKey(e:KeyboardEvent):void{
        release();
    }
    


    
    private function rollOver(e:MouseEvent=null):void {
        var overColorTrans:ColorTransform = new ColorTransform();
        overColorTrans.color = color3;
        icon.transform.colorTransform = overColorTrans;
    }
    private function rollOut(e:MouseEvent=null):void {
        var overColorTrans:ColorTransform = new ColorTransform();
        if(input.text.length==0)overColorTrans.color = color2;
        else overColorTrans.color = color1;
        icon.transform.colorTransform = overColorTrans;
    }
    private function press(e:MouseEvent=null):void {
        icon.y = 1;
        
    }
    private function release(e:MouseEvent=null):void {
        icon.y = 0;
    }

}



//検索
class SearchIcon extends Shape {
    private static var bColor:uint = 0x000000;
    public function SearchIcon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawCircle(0,-1,5);
        graphics.drawCircle(0,-1,6.5);
        graphics.endFill();
        
        graphics.lineStyle(3,bColor);
        graphics.moveTo(-7,7); 
        graphics.lineTo(-4,4);
    }

}