/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kn7T
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.getTimer;
    
    import com.bit101.components.*;
    
    public class Main extends Sprite 
    {
        private var area:TextArea;
        private var tx:Text;
        private var btn:PushButton;
        private var obj:CustomDispatcher;
        
        public function Main():void 
        {
            init();
        }
        
        private function init(e:Event = null):void 
        {            
            btn = new PushButton(stage, 300, 0, "push", onClick);
            
            area = new TextArea(stage, 0, 0);
            area.setSize(150, stage.stageHeight);
            
            tx = new Text(stage, 150, 0);
            tx.setSize(150, stage.stageHeight);
            
            obj = new CustomDispatcher();
            obj.addEventListener(CustomDispatcher.START, onStart);
            obj.addEventListener(CustomDispatcher.PROCEED, onProceed);
            obj.addEventListener(CustomDispatcher.DONE, onDone);
        }
        
        private function onStart(event:Event):void
        {
            area.text = "";
            area.text += "start\n";
            tx.text = "";
            tx.text += "start\n";
        }
        
        private function onProceed(event:Event):void
        {
            area.text += "proceed\n";
            tx.text += "proceed\n";
        }
        
        private function onDone(event:Event):void
        {
            area.text += "done\n";
            tx.text += "done\n";
        }
        
        private function onClick(event:MouseEvent):void
        {
            var time:int = getTimer();
            obj.start();
            for (var i:int = 0; i < 10; i++)
            {
                for (var j:int = 0; j < 1000; j++) 
                {
                    var sp:Sprite = new Sprite();
                    sp.graphics.beginFill(0);
                    sp.graphics.drawCircle(0, 0, 10);
                    sp.graphics.endFill();
                }
                area.text += (getTimer() - time).toString() + "sec\n";
                tx.text += (getTimer() - time).toString() + "sec\n";
                obj.proceed();
            }
            obj.done();
        }
    }
}


    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.events.IEventDispatcher;
    
    class CustomDispatcher implements IEventDispatcher
    {
        
        public static const START:String = "start";
        public static const PROCEED:String = "proceed";
        public static const DONE:String = "done";
        
        private var _dispatcher:EventDispatcher;
        
        public function CustomDispatcher() 
        {
            _dispatcher = new EventDispatcher(this);
        }
        
        public function start():void
        {
            dispatchEvent(new Event(CustomDispatcher.START));
        }
        
        public function done():void
        {
            dispatchEvent(new Event(CustomDispatcher.DONE));
        }
        
        public function proceed():void
        {
            dispatchEvent(new Event(CustomDispatcher.PROCEED));
        }
        
        //**インターフェイス**//
        
        public function addEventListener(type:String, listener:Function, useCapture:Boolean = false, priority:int = 0, useWeakReferece:Boolean = false) :void
        {
            _dispatcher.addEventListener(type, listener, useCapture, priority, useWeakReferece);
        }
        
        public function dispatchEvent(event:Event):Boolean
        {
            return _dispatcher.dispatchEvent(event);
        }
        
        public function hasEventListener(type:String):Boolean
        {
            return _dispatcher.hasEventListener(type);
        }
        
        public function removeEventListener(type:String, listener:Function, useCapture:Boolean = false):void
        {
            _dispatcher.removeEventListener(type, listener, useCapture);
        }
        
        public function willTrigger(type:String):Boolean
        {
            return _dispatcher.willTrigger(type);
        }
        
    }