/**
 * Copyright mtok ( http://wonderfl.net/user/mtok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kn6k
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
	import flash.utils.getTimer;
	import flash.display.BlendMode;
	
    public class Professional extends Sprite {
        private var rcanvas:Sprite;
        private var gcanvas:Sprite;
        private var bcanvas:Sprite;
		
		public function Professional() {
			
			
			addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
		
		private function addedToStageHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);

            stage.scaleMode = StageScaleMode.NO_SCALE;
			graphics.beginFill(0x000000);
			graphics.drawRect(0, 0, 480, 480);
			graphics.endFill();
			
			addChild(rcanvas = new Sprite());
			addChild(gcanvas = new Sprite());
			addChild(bcanvas = new Sprite());
			
			var sw:int = stage.stageWidth;
			var sh:int = stage.stageHeight;
			rcanvas.x = gcanvas.x = bcanvas.x = sw * 0.5;
			rcanvas.y = gcanvas.y = bcanvas.y = sh * 0.5;

			rcanvas.blendMode = BlendMode.ADD;
			gcanvas.blendMode = BlendMode.ADD;
			bcanvas.blendMode = BlendMode.ADD;

			var pr:BitmapData = genPattern(0xffff0000);
			var pg:BitmapData = genPattern(0xff00ff00);
			var pb:BitmapData = genPattern(0xff0000ff);
			
			fillPattern(rcanvas.graphics, pr, -sw, -sh, 2*sw, 2*sh);
			fillPattern(gcanvas.graphics, pg, -sw, -sh, 2*sw, 2*sh);
			fillPattern(bcanvas.graphics, pb, -sw, -sh, 2*sw, 2*sh);

			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			var t:Number = getTimer() * 0.001;
			var s:Number = Math.sin(t);

			var mx:Number = mouseX - stage.stageWidth * 0.5;
			var my:Number = mouseY - stage.stageHeight * 0.5;

			rcanvas.rotationY = 0 + s * 5;
			gcanvas.rotationY = 0 + s * 5 * mx /stage.stageWidth;
			bcanvas.rotationX = 0 + s * 5 * my / stage.stageHeight;
		}
        
		public function fillPattern(g:Graphics, pattern:BitmapData, x:int = 0, y:int = 0, w:int = 480, h:int = 480):void {
            g.beginBitmapFill(pattern);
            g.drawRect(x, y, w, h);
            g.endFill();		
		}
		
        //most simple patern
        public function genPattern(c:uint):BitmapData{
            return BitmapPatternBuilder.build(
                [
				 [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0]
				],
                [0xff000000, c]
            );
        }
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}