/**
 * Copyright Cao ( http://wonderfl.net/user/Cao )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kmFX
 */

package
{
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import frocessing.color.ColorHSV;
 
    public class Main extends Sprite
    {
        private const WIDTH:int = 200;
        private const HEIGHT:int = 200;
 
        public function Main()
        {
            Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
            loader.load(new URLRequest("http://farm3.static.flickr.com/2047/2280715132_f0a72c1088.jpg"), new LoaderContext(true)); // 読み込みたい画像URL
        }
 
        private function initHandler(event:Event):void
        {
            var loader:Loader = event.currentTarget.loader;
 
            var matrix:Matrix = new Matrix();
            matrix.scale(WIDTH / loader.width, HEIGHT / loader.height);
 
            var bd:BitmapData = new BitmapData(WIDTH, HEIGHT);
            bd.draw(loader, matrix);
            addChild(new Bitmap(binarization(bd)));
        }
 
        private function binarization(bd:BitmapData):BitmapData
        {
            var dest:BitmapData = bd.clone();
            var color:ColorHSV = new ColorHSV();
 
            for (var y:int = 0; y < bd.height; y++)
            {
                for (var x:int = 0; x < bd.width; x++)
                {
                    color.value = bd.getPixel(x, y);
                    var gray:Number = (color.r + color.g + color.b) / 3;
                    if (gray <= 0x7F)
                    {
                        dest.setPixel(x, y, 0x0);
                    }
                    else 
                    {
                        dest.setPixel(x, y, 0xFFFFFF);
                    }
                }
            }
 
            return dest;
        }
    }
}