/**
 * Copyright undo ( http://wonderfl.net/user/undo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kltD
 */

// forked from tjoen's Flower Power
package 
{
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import frocessing.display.*;

    public class FlowerPower extends F5MovieClip2DBmp
    {
        private var m_stage_width:Number  = 485;
        private var m_stage_height:Number = 485;
        private var m_flower_base:Point;
        private var m_flower_size:Number;
        private var m_flower_step:Number;
        private var m_flower_current_size:Number;
        private var m_kaben_num:int;       
           
        public function FlowerPower(){
            super();
        }
       
        public function setup():void {
           
            size( m_stage_width, m_stage_height );
           
            background(0, 1);  // color, alpha
           
            setFlower();
        }
       
        public function setFlower():void {
           
            m_flower_base = new Point(random(m_stage_width), random(m_stage_height));
            m_flower_size = random(200, 20);
            m_flower_step = m_flower_size / 10; 
            m_flower_current_size = m_flower_step;
           
            m_kaben_num = random(8, 3);
        }
       
        public function draw():void {
            
            bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(0, 0), new BlurFilter(10, 0));

            translate( 0, 0);
 
            noFill();

            stroke(Math.random()*0xffffff, 0.7);  //color, alpha
           
            var kaben_num:int = m_kaben_num;
            var kaben_angle:Number = radians(360 / kaben_num);
            var kaben_len:int = m_flower_current_size / 2;
           
            var base_x:Number = m_flower_base.x;
            var base_y:Number = m_flower_base.y;
           
            beginShape();
            curveVertex(base_x, base_y);
            for (var i:int = 0; i <kaben_num ; i++) {
                var x1:Number = cos(kaben_angle * i - kaben_angle / 3) * kaben_len / 2 + base_x;
                var y1:Number = sin(kaben_angle * i - kaben_angle / 3) * kaben_len / 2 + base_y;               
                var x2:Number = cos(kaben_angle * i) * kaben_len + base_x;
                var y2:Number = sin(kaben_angle * i) * kaben_len + base_y;
                var x3:Number = cos(kaben_angle * i + kaben_angle / 3) * kaben_len / 2 + base_x;
                var y3:Number = sin(kaben_angle * i + kaben_angle / 3) * kaben_len / 2 + base_y;                       
                curveVertex(base_x, base_y);
                curveVertex(x1, y1);
                curveVertex(x2, y2);
                curveVertex(x3, y3);
                curveVertex(base_x, base_y);
            }
            curveVertex(base_x, base_y);
            endShape();
           
            m_flower_current_size += m_flower_step;
           
            if (m_flower_current_size> m_flower_size) {
                setFlower();
               
            }
        }
       
        public function reset():void {
           
            background(0, 1);
        }
    }
}