/**
 * Copyright Hiiragi ( http://wonderfl.net/user/Hiiragi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/klNS
 */

package  {
    
    import flash.display.Sprite;
    import flash.events.Event;
    import idv.cjcat.stardust.common.actions.Age;
    import idv.cjcat.stardust.common.actions.DeathLife;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.initializers.Life;
    import idv.cjcat.stardust.common.math.UniformRandom;
    import idv.cjcat.stardust.threeD.actions.Move3D;
    import idv.cjcat.stardust.threeD.actions.VelocityField3D;
    import idv.cjcat.stardust.threeD.actions.StardustSpriteUpdate3D;
    import idv.cjcat.stardust.threeD.emitters.Emitter3D;
    import idv.cjcat.stardust.threeD.handlers.DisplayObjectHandler3D;
    import idv.cjcat.stardust.threeD.initializers.DisplayObjectClass3D;
    import idv.cjcat.stardust.threeD.initializers.Position3D;
    import idv.cjcat.stardust.threeD.initializers.Velocity3D;
    import idv.cjcat.stardust.threeD.zones.CubeZone;
    
    /**
     * Stardustで紙吹雪的な。
     * 
     * かなり今更感のある感じですが・・・。
     * しかもヒラヒラ舞わないから、微妙なのだけど。
     * 1.3からEmitterにparticleHandlerが必要になったんで注意。
     * でも見て判るとおり、rendererが、emitterのhandlerになっただけっぽい。
     * 
     * 参考：
     * http://stardust-particle-engine.googlecode.com/svn/trunk/examples/3D/Stardust%203D/Sakura/Sakura.html
     * http://wonderfl.net/c/tLIW
     * 
     */
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0x0")]
    public class Main extends Sprite
    {
        private var _emitter:Emitter3D;
        
        public function Main()
        {
            _emitter = new Emitter3D(new SteadyClock(1));
            _emitter.particleHandler = new DisplayObjectHandler3D(this);
            
            _emitter.addInitializer(new DisplayObjectClass3D(RectPaper));
            _emitter.addInitializer(new Position3D(new CubeZone(0, 0, 0, 5000, -200, 30)));
            _emitter.addInitializer(new Velocity3D(new CubeZone(-20, 20, 0, 40, 20, 0)));
            _emitter.addInitializer(new Life(new UniformRandom(150, 0)));
            
            _emitter.addAction(new Age());
            _emitter.addAction(new DeathLife());
            _emitter.addAction(new Move3D());
            _emitter.addAction(new StardustSpriteUpdate3D());
            
            this.addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
        }
        
        private function onEnterFrameHandler(e:Event):void 
        {
            _emitter.step();
        }
    }
}



import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;

import idv.cjcat.stardust.common.emitters.Emitter;
import idv.cjcat.stardust.common.particles.Particle;
import idv.cjcat.stardust.twoD.display.StardustSprite;

class RectPaper extends StardustSprite
{
    private var _canvas:BitmapData;
    private var _bmp:Bitmap;
    
    private var innerWrapper:Sprite;
    private var selfOmega:Number;
    private var petalOmega:Number;
    private var scaleXRate:Number;
    private var phase:Number;
    
    public function RectPaper() {
        _canvas = new BitmapData(40, 30, false, ColorUtil.HSVtoRGB(Math.random() * 360));
        _bmp = new Bitmap(_canvas);
        
        phase = 0;
        innerWrapper = new Sprite();
        innerWrapper.addChild(_bmp);
        _bmp.rotation = Math.random() * 360;
        rotation *= Math.random() * 360;
        selfOmega = Math.random() * 10;
        petalOmega = Math.random() * 10;
        scaleXRate = Math.random() * 0.03 + 0.07;
        addChild(innerWrapper);
    }
    
    override public function update(emitter:Emitter, particle:Particle, time:Number):void {
        _bmp.rotation += petalOmega;
        rotation += selfOmega;
        phase++;
        innerWrapper.scaleX = Math.sin(scaleXRate * phase);
    }

}


class ColorUtil extends Object
{
    
    public static function HSVtoRGB(hue:Number, saturation:Number = 1,  value:Number = 1):uint
    {
        var Hi:int  = Math.floor(hue / 60) % 6;
        var f:Number = hue / 60 - Hi;
        var p:Number = value * (1 - saturation);
        var q:Number = value * (1 - f * saturation);
        var t:Number = value * (1 - (1 - f) * saturation);
        
        var r:Number = 0;
        var g:Number = 0;
        var b:Number = 0;
        
        switch (Hi) {
            case 0:
                r=value; g=t; b=p;
                break;
            case 1:
                r=q; g=value; b=p;
                break;
            case 2:
                r=p; g=value; b=t;
                break;
            case 3:
                r=p; g=q; b=value;
                break;
            case 4:
                r=t; g=p; b=value;
                break;
            case 5:
                r=value; g=p; b=q;
                break;
        }
        
        r = Math.floor(r*255);
        g = Math.floor(g*255);
        b = Math.floor(b * 255);
        
        return r << 16 | g << 8 | b;
    }
}