/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kkof
 */

// forked from shapevent's Distance Spring
package {

	import flash.display.*;
	import flash.geom.*;
	import flash.events.*;
        import flash.utils.getTimer;


	[SWF(backgroundColor=0x222222, width=500, height=500)]

       public class DistSpring extends MovieClip {
		private var hsw:Number;
		private var hsh:Number;
		private var pointNum:int;
		private var points3D:Vector.<Number>;
		private var points3Dout:Vector.<Number>;
		private var points2D:Vector.<Number>;
		private var uvts:Vector.<Number>;
		private var sorted:Array;
		private var pnt:Point;
		private var m:Matrix3D;
		private var v:Vector3D;
		private var p:PerspectiveProjection;
		private var proj:Matrix3D;
		private var dx:Number;
		private var dy:Number;


               public function DistSpring(){
                  // init 
			hsw = stage.stageWidth / 2;
			hsh = stage.stageHeight / 2;
			pointNum = 800
			points3D = new Vector.<Number>();
			points3Dout = new Vector.<Number>();
			points2D = new Vector.<Number>();
			uvts = new Vector.<Number>();
			sorted = [];
			pnt = new Point();
			m = new Matrix3D();
			v = new Vector3D();
			for (var i:int = 0; i<pointNum; i++){
				v.y = i * 0.7 - 300
				var t:Number = Math.random()*6.28;
				v.x = 200 * Math.cos(i * 2 * Math.PI / 180);
				v.z = 200 * Math.sin(i * 2 * Math.PI / 180);
				v = m.transformVector(v);
				points3D.push(v.x, v.y, v.z);
				points2D.push(0,0);
				uvts.push(0,0,0);
				sorted.push(new Vector3D());
			}
			points3D.fixed = true;
			points2D.fixed = true;
			uvts.fixed = true;
			p = new PerspectiveProjection();
			proj = p.toMatrix3D();
			dx = 0, dy = 0;
			addEventListener(Event.ENTER_FRAME, onLoop);
			

               }
               // private methods

		private function onLoop(evt:Event):void {
			var i:int, j:int;
                        graphics.clear();
                       // graphics.lineStyle(0xff0000,3);
                      //  graphics.lineTo(100,100);
			dx += (mouseX - dx) / 4;
			dy += (mouseY - dy) / 4;
			m.identity();
			m.appendRotation(getTimer() / 4, Vector3D.Y_AXIS);
			m.transformVectors(points3D, points3Dout);
			
			m.identity();
			m.appendRotation(dx, Vector3D.Z_AXIS);
			m.appendRotation(dy, Vector3D.X_AXIS);
			m.appendTranslation(0, 0, 1000);
			m.append(proj);
			Utils3D.projectVectors(m, points3Dout, points2D, uvts);
			for (i = 0, j = 0; i<points2D.length; i+=2, j++){
				sorted[j].x = points2D[i] + hsw;
				sorted[j].y = points2D[i + 1] + hsh;
				sorted[j].z = uvts[j * 3 + 2];
			}
			sorted.sortOn("z", Array.NUMERIC);
			//graphics.clear();
			for(i = 0; i<sorted.length; i++){
				var zpos:Number = sorted[i].z * 1000;
				var c:int = zpos * 14;
				graphics.beginFill(c <<16 | c <<8 | c);
				graphics.drawCircle(sorted[i].x, sorted[i].y, 5);
				graphics.endFill();
			}
		}
		

       }

}