/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kk5z
 */

// forked from ProjectNya's ドット (1)
////////////////////////////////////////////////////////////////////////////////
// ドット (1)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.system.Security;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var base:Sprite;
        private var canvas:BitmapData;
        private var dots:Array;
        private var filePath:String = "http://assets.wonderfl.net/images/related_images/3/37/37f5/37f5f9a17dfa799dadba38e45e568d4da9b4ee23";

        public function Main() {
            Wonderfl.capture_delay(8);
            init();
        }

        private function init():void {
            Security.allowDomain("assets.wonderfl.net");
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
            
            base = new Sprite();
            base.graphics.beginFill(0x000000);
            base.graphics.drawRect(0, 0, 465, 465);
            base.graphics.endFill();
            addChild(base);
            canvas = new BitmapData(465, 465, false, 0xFF000000);
            var bitmap:Bitmap = new Bitmap(canvas);
            addChild(bitmap);
            var loader:Loader=new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(filePath));
        }
        private function complete(evt:Event):void {
            var content:Bitmap = evt.target.content;
            content.x = int((465 - content.width)/2);
            content.y = int((465 - content.height)/2);
            initialize(content);
        }
        private function initialize(bitmap:Bitmap):void {
            var bitmapData:BitmapData = bitmap.bitmapData;
            dots = new Array();
            for (var i:uint = 0; i < bitmapData.height; i++) {
                for (var j:uint = 0; j < bitmapData.width; j++) {
                    var tx:uint = j + bitmap.x;
                    var ty:uint = i + bitmap.y;
                    var dot:Dot = new Dot(tx, ty);
                    var color:uint = bitmapData.getPixel(j, i);
                    dot.color = color;
                    dots.push(dot);
                }
            }
            base.buttonMode = true;
            base.addEventListener(MouseEvent.CLICK, click, false, 0, true);
        }
        private function click(evt:MouseEvent):void {
            base.mouseEnabled = false;
            base.useHandCursor = false;
            start();
        }
        private function start():void {
            for (var n:uint = 0; n < dots.length; n++) {
                var dot:Dot = dots[n];
                dot.x = uint(Math.random()*800) - 400 + 232;
                
                dot.y = uint(Math.random()*800) - 400 + 232;
                
                dot.completed = false;
            }
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        
        private function stop():void {
            removeEventListener(Event.ENTER_FRAME, update);
            base.mouseEnabled = true;
            base.useHandCursor = true;
        }
        
        private function update(evt:Event):void {
            canvas.lock();
            canvas.fillRect(canvas.rect, 0xFF000000);
            var completed:uint = 0;
            for (var n:uint = 0; n < dots.length; n++) {
                var dot:Dot = dots[n];
                dot.x += (dot.tx - dot.x)*0.2;
                dot.y += (dot.ty - dot.y)*0.2;
                canvas.setPixel(dot.x, dot.y, dot.color);
                if (!dot.completed) {
                    canvas.setPixel(dot.x, dot.y, dot.color);
                } else {
                    completed ++;
                    if (completed > dots.length - 1) {
                        stop();
                    }
              }
               if (Math.abs(dot.tx - dot.x) < 0.5 && Math.abs(dot.ty - dot.y) < 0.5) {
                    dot.x = dot.tx;
                   dot.y = dot.ty;
                   dot.completed = true;
                  canvas.setPixel(dot.x, dot.y, dot.color);
               }
           }
            canvas.unlock();
        }

    }

}


//////////////////////////////////////////////////
// Dotクラス
//////////////////////////////////////////////////

class Dot {
    public var x:Number = 0;
    public var y:Number = 0;
    public var tx:int = 0;
    public var ty:int = 0;
    public var color:uint;
    public var completed:Boolean = false;

    public function Dot(x:int, y:int) {
        tx = x;
        ty = y;
    }

}
