/**
 * Copyright mirrorboy ( http://wonderfl.net/user/mirrorboy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kjT4
 */

package
{
    import flash.system.LoaderContext;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.text.TextField;
    
    public class RenderingTriangles extends Sprite
    {
        private var _anchors:Vector.<Sprite>;
        private var _anchor:Sprite;
        private var _anchorIndex:uint;
        private var _vertices:Vector.<Number>;
        private var _indices:Vector.<int>;
        private var _uvtData:Vector.<Number>;
        private var _image:BitmapData;
        
        public function RenderingTriangles()
        {
            loadImage();    
        }
        
        private function loadImage():void{
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onImageLoaded);
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/7/7a/7a93/7a9370d178ea15eba65cc1240c8265ced8132c70"),new LoaderContext(true));
        }
        
        private function defineTriangles():void{
        
            var border:Number = 50;
            var width:Number = stage.stageWidth;
            var height:Number = stage.stageHeight;
            
            _anchors = new Vector.<Sprite>();
            addAnchor(border,border);
            addAnchor(width-border,border);
            addAnchor(width/2,height/2);
            addAnchor(border,height-border);
            addAnchor(width-border,height-border);
            
            _vertices = new Vector.<Number>();
            for each(var anchor:Sprite in _anchors){
                _vertices.push(anchor.x,anchor.y);
            }
            
            _indices = new Vector.<int>();
            _indices.push(1,0,2);
            _indices.push(0,2,3);
            _indices.push(1,2,4);
            _indices.push(2,3,4);
            
            _uvtData = new Vector.<Number>();
            _uvtData.push(0,0);
            _uvtData.push(1,0);
            _uvtData.push(.5,.5);
            _uvtData.push(0,1);
            _uvtData.push(1,1);
        }
        
        private function addAnchor(x:Number,y:Number):void{
            
            var anchor:Sprite = new Sprite();
            anchor.graphics.lineStyle(20,0xFFD000);
            anchor.graphics.lineTo(1,0);
            anchor.addEventListener(MouseEvent.MOUSE_DOWN,onAnchorDown);
            anchor.addEventListener(MouseEvent.MOUSE_UP,onAnchorUp);
            anchor.x = x;
            anchor.y = y;
            var label:TextField = new TextField();
            label.x = -4;
            label.y = -9;
            label.mouseEnabled = false;
            label.textColor = 0xFFFFFF;
            label.text = String(_anchors.length);
            anchor.addChild(label);
            addChild(anchor);
            _anchors.push(anchor);
        }
        
        private function draw():void{
            graphics.clear();
            graphics.beginBitmapFill(_image);
            graphics.drawTriangles(_vertices,_indices,_uvtData);
            graphics.endFill();
        }
        
        private function onAnchorDown(event:MouseEvent):void{
            _anchor = event.target as Sprite;
            _anchor.startDrag();
            _anchorIndex = _anchors.indexOf(_anchor);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onAnchorMove);
        }
        
        private function onAnchorMove(event:MouseEvent):void{
            _vertices[_anchorIndex * 2] = _anchor.x;
            _vertices[_anchorIndex * 2 + 1] = _anchor.y;
            draw();
            event.updateAfterEvent();
        }
        
        private function onAnchorUp(event:MouseEvent):void{event
        
            if(_anchor){
                _anchor.stopDrag();
                stage.removeEventListener(MouseEvent.MOUSE_MOVE,onAnchorMove);
            }
        }
        
        private function onImageLoaded(event:Event):void{
        
            var loaderInfo:LoaderInfo = event.target as LoaderInfo;
            var bitmap:Bitmap = loaderInfo.content as Bitmap;
            _image = bitmap.bitmapData;
            defineTriangles();
            draw();
            
        }
    }
}