/**
 * Copyright hiphi ( http://wonderfl.net/user/hiphi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kj52
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
    		private var cam:Camera;
        public function FlashTest() {
            // write as3 code here..
            
            //カメラの設定
			cam = new Camera();
			cam.screenZ = 300;	
			cam.x = 0;
			cam.y = 0;
			cam.z = -300;
			
			//オブジェクトの生成
			var i:uint = 0;
			var len:uint = particleNum;
			var tAry:Array = ["circle","rectangle","triangle"];
			
			for(i;i<len;i++)
			{
				var p_type:String = tAry[Math.floor(Math.random()*tAry.length)];
				var p_size:Number = Math.random()*5+5;
				//COLOR
				var redCol:Number = 200*Math.random()+56;
				var grnCol:Number = 200*Math.random()+56;
				var bluCol:Number = 1*Math.random()+128;
				var p_col:Number  = (redCol << 16) + (grnCol <<8) + bluCol;
				
				var p:Particle = new Object();
				p.col  = p_col;
				p.type = p_type;
				p.size = p_size;
				p.px = 0;
				p.targetX = Math.random()*stage.stageWidth - Math.floor(stage.stageWidth/2);
				p.py = 0;
				p.targetY = Math.random()*stage.stageHeight - Math.floor(stage.stageHeight/2);
				p.pz = 0;
				p.targetZ = 0;
				p.friction = 0.76;
				
				addChild(p.pGraphics);
				pAry.push(p);
			}
        }
         /*======================================================================*//**
		 *スクリーン座標に変換
		 */
		public static function screenView(cam:Camera, shape:*):Object
		{
			var pointArray:* = shape;
			
			var px:Number = (pointArray.px + pointArray.centerX) - cam.x;
			var py:Number = (pointArray.py + pointArray.centerY) - cam.y;
			var pz:Number = (pointArray.pz + pointArray.centerZ) - cam.z;
				
			var _dy1:Number =  py*Math.cos(cam.rotationX) + pz*Math.sin(cam.rotationX);
			var _dz1:Number = -py*Math.sin(cam.rotationX) + pz*Math.cos(cam.rotationX);
				
			var _dx1:Number = px*Math.cos(cam.rotationY) - _dz1*Math.sin(cam.rotationY);
			var _dz2:Number = px*Math.sin(cam.rotationY) + _dz1*Math.cos(cam.rotationY);
				
			var _dx2:Number =  _dx1*Math.cos(cam.rotationZ) + _dy1*Math.sin(cam.rotationZ);
			var _dy2:Number = -_dx1*Math.sin(cam.rotationZ) + _dy1*Math.cos(cam.rotationZ);
			
			var obj:Object = new Object();
			obj.px = _dx2*(cam.screenZ/_dz2);
			obj.py = _dy2*(cam.screenZ/_dz2);
			obj.pz = cam.screenZ/(_dz2);
			obj.object = pointArray;
			
			/*trace("obj.px:"+obj.px);
			trace("obj.py:"+obj.py);
			trace("obj.pz:"+obj.pz);*/
			
			return obj;
		}
		
		/*======================================================================*/
		/**
		 * X軸回転
		 * @param theta = ラジアン
		 */
		public function rotAxisX(theta:Number, pointAry:*):*
		{
			var obj:Object = new Object();
			var _dy:Number,_dz:Number,_cy:Number,_cz:Number;
			var rot:Number = theta;
				
			_dy =  pointAry.py*Math.cos(rot) + pointAry.pz*Math.sin(rot);
			_dz = -pointAry.py*Math.sin(rot) + pointAry.pz*Math.cos(rot);
			
			obj.px = pointAry.px;
			obj.py = _dy;
			obj.pz = _dz;
				
			return obj;
		}
			
		 /*======================================================================*/
		/**
		 * Y軸回転
		 * @param theta = ラジアン
		 */
		public function rotAxisY(theta:Number, pointAry:*):*
		{
			var obj:Object = new Object();
			var _dx:Number,_dz:Number,_cy:Number,_cz:Number;
			var rot:Number = theta;
				
			_dx = pointAry.px*Math.cos(rot) - pointAry.pz*Math.sin(rot);
			_dz = pointAry.px*Math.sin(rot) + pointAry.pz*Math.cos(rot);
				
			obj.px = _dx;
			obj.py = pointAry.py;
			obj.pz = _dz;
			
			return obj;
		}
			
		/*======================================================================*/
		/**
		 * Z軸回転
		 * @param theta = ラジアン
		 */
		public function rotAxisZ(theta:Number, pointAry:*):*
		{
			var obj:Object = new Object();
			var _dx:Number,_dy:Number,_cy:Number,_cz:Number;
			var rot:Number = theta;

			_dx =  pointAry.px*Math.cos(rot) + pointAry.py*Math.sin(rot);
			_dy = -pointAry.px*Math.sin(rot) + pointAry.py*Math.cos(rot);

			obj.px = _dx;
			obj.py = _dy;
			obj.pz = pointAry.pz;
				
			return obj;
		}
    }
    
    //CAMERAクラス
    public class Camera
	{
		public var rotationX:Number = 0;
		public var rotationY:Number = 0;
		public var rotationZ:Number = 0;
		
		public var x:Number = 0;
		public var y:Number = 0;
		public var z:Number = 0;
		public var screenZ:Number = 0;
		
		public function Camera()
		{
			this.init();
		}
		protected function init():void
		{
			
		}
	}
}