/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kitM
 */

// forked from kotobuki's Simple Sound Player
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import flash.net.URLRequest;
    import funnel.*;
    import funnel.ui.*;

    public class SimpleSoundPlayer extends Sprite {
        // これはMac OS Xの場合にはパーソナルウェブ共有、Windowsの場合には
        // AN HTTPDなどを使用してローカルでサーバを用意することを想定した
        // URLです。
        private const URL_OF_SOUND_FILE:String = "http://localhost/sounds/snare.mp3";

        private var _sound:Sound;

        private var _gainer:Gainer;

        public function SimpleSoundPlayer() {
            _sound = new Sound();
            _sound.addEventListener(Event.COMPLETE, onLoadComplete);
            _sound.load(new URLRequest(URL_OF_SOUND_FILE));

            _gainer = new Gainer();
        }

        private function onLoadComplete(e:Event):void {
            // サンプルのロードが完了したらボタンプレスで再生するように
            // イベントリスナをセットする
            _gainer.button.addEventListener(ButtonEvent.PRESS, onButtonPress);
        }

        private function onButtonPress(e:ButtonEvent):void {
            // MP3にエンコードした時に頭に空白が入ってしまうため
            // スタートポイントを30ms後にしてレスポンスを改善する
            _sound.play(30);
        }
    }
}
