/**
 * Copyright hacker_gwxs5acj ( http://wonderfl.net/user/hacker_gwxs5acj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kiIV
 */

// forked from alumican_net's [CHECKMATE] Stardust Rainbow
/**
 * Stardust Rainbow
 * 長い時間見続けると酔うという、いわくつきのFlash
 * 
 * forked from checkmate's Saqoosha challenge for amateurs
 */
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import org.libspark.betweenas3.easing.Quint;
	
	[SWF(width = 465, height = 465, backgroundColor = 0x0, frameRate = 30)]
	public class StardustRainbow extends Sprite
	{
		//-------------------------------------
		//CLASS CONSTANTS
		
		private const W:uint = 465;
		private const H:uint = 465;
		
		private const SPRING:Number   = 0.96;
		private const FRICTION:Number = 0.15;
		
		private const PI:Number    = Math.PI;
		private const PI2:Number   = PI * 2;
		private const PI1_2:Number = PI * 0.5;
		
		private const ZEROS:Point    = new Point(0, 0);
		private const RECT:Rectangle = new Rectangle(0, 0, W, H);
		
		
		
		
		
		//-------------------------------------
		//VARIABLES
		
		private var _gradation:Gradation;
		private var _container:Sprite;
		private var _particles:Array;
		
		private var _blurFilter:BlurFilter;
		
		private var _canvasFront:BitmapData;
		private var _canvasBlur:BitmapData;
		
		private var _px:Number;
		private var _py:Number;
		
		private var _ox:Number;
		private var _oy:Number;
		
		private var _vx:Number;
		private var _vy:Number;
		
		static public var starShapeX:Array;
		static public var starShapeY:Array;
		
		
		
		
		
		//-------------------------------------
		//METHODS
		
		public function StardustRainbow():void 
		{
			Wonderfl.disable_capture();
			addEventListener(Event.ADDED_TO_STAGE, _initialize);
		}
		
		/**
		 * EntryPoint
		 */
		private function _initialize(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, _initialize);
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.quality   = StageQuality.LOW;
			
			//虹色グラデーション
			_gradation = new Gradation(0xff0000, 0xff8000, 0xffff00, 0x00ff00, 0x00ffff, 0x0000ff, 0x8000ff);
			_gradation.setEasing(Quint.easeInOut);
			
			_container = new Sprite();
			_particles = new Array();
			
			addChild(new Bitmap( _canvasFront = new BitmapData(W, H, true, 0x0) ) ) as Bitmap;
			_canvasBlur = _canvasFront.clone();
			
			_blurFilter = new BlurFilter(48, 48, 1);
			
			_ox = _px = mouseX;
			_oy = _py = mouseY;
			_vx = _vy = 0;
			
			starShapeX = new Array(10);
			starShapeY = new Array(10);
			for (var i:uint = 0; i < 10; ++i) 
			{
				var angle:Number = (i / 10) * Math.PI * 2;
				var s:Number = (i % 2 == 0) ? 10 : 10 * 0.5;
				starShapeX[i] = s * Math.cos(angle);
				starShapeY[i] = s * Math.sin(angle);
			}
			
			addEventListener(Event.ENTER_FRAME, _update);
		}
		
		/**
		 * Updator
		 */
		private function _update(e:Event):void 
		{
			var dx:Number = mouseX - _px,
				dy:Number = mouseY - _py,
				ax:Number = dx * SPRING,
				ay:Number = dy * SPRING,
				p:Star,
				a:Number,
				i:int,
				n:int = _particles.length,
				angle:Number = Math.atan2(_vy, _vx);
			
			_vx += ax;
			_vy += ay;
			_px += _vx;
			_py += _vy;
			
			for (i = n - 1; i >= 0; --i) 
			{
				p     = _particles[i];
				p.v += p.a;
				p.x += p.v * Math.cos(p.angle);
				p.y += p.v * Math.sin(p.angle);
				
				p.rotation += p.rot;
				p.scaleX = p.scaleY += p.v * 0.01;
				
				//画面外のは削除
				if (p.x < 0 || p.x > W || p.y < 0 || p.y > H)
				{
					_container.removeChild( _particles.splice(i, 1)[0] );
				}
			}
			
			n = 20;
			for (i = 0; i < n; ++i) 
			{
				p    = new Star();
				p.x  = mouseX;
				p.y  = mouseY;
				p.a  = 1.0 + (Math.random() - 0.5) * 0.2;
				p.v = 0;
				p.rot = (Math.random() - 0.5) * 10;
				p.rotation = Math.random() * PI2;
				p.angle = angle * 2 + (i - n / 2) * 0.2 + PI1_2;
				p.createShape(_gradation.getColor(i / n));
				p.blendMode = BlendMode.ADD;
				_container.addChildAt(p, 0);
				_particles.push(p);
			}
			
			_vx *= FRICTION;
			_vy *= FRICTION;
			
			_ox  = _px;
			_oy  = _py;
			
			//drawing
			_canvasFront.lock();
			_canvasBlur.lock();
			
			_canvasFront.fillRect(RECT, 0x0);
			_canvasFront.draw(_container);
			
			_canvasBlur.copyPixels(_canvasFront, RECT, ZEROS);
			_canvasBlur.applyFilter(_canvasBlur, RECT, ZEROS, _blurFilter);
			
			_canvasFront.draw(_canvasBlur);
			
			_canvasFront.unlock();
			_canvasBlur.unlock();
		}
	}
}

import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
class Star extends Sprite
{
	public var a:Number;
	public var v:Number;
	public var angle:Number;
	public var rot:Number;
	
	public function Star():void
	{
	}
	
	public function createShape(color:uint):void
	{
		var i:uint;
		var g:Graphics = graphics;
		
		g.beginFill(color, 1);
		g.moveTo(StardustRainbow.starShapeX[0], StardustRainbow.starShapeY[0]);
		for (i = 0; i < 10; ++i) g.lineTo(StardustRainbow.starShapeX[i], StardustRainbow.starShapeY[i]);
		g.moveTo(StardustRainbow.starShapeX[0] * 0.5, StardustRainbow.starShapeY[0] * 0.5);
		for (i = 0; i < 10; ++i) g.lineTo(StardustRainbow.starShapeX[i] * 0.5, StardustRainbow.starShapeY[i] * 0.5);
		g.endFill();
	}
}

/**
 * @author saqoosha
 * @see http://wonderfl.net/code/7ed2d650b9d513edf9a499fb704c19ecb7aa4694
 */
import frocessing.color.ColorLerp;
import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;
class Gradation
{
	private var _colors:Array;
	private var _easing:IEasing;
	
	public function Gradation(...args):void
	{
		_colors = args.concat();
		_easing = Linear.linear;
	}
	
	public function setEasing(easing:IEasing):void
	{
		_easing = easing;
	}
	
	public function getColor(position:Number):uint
	{
		position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
		var idx:int = position;
		var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
		if (alpha == 0)
		{
			return _colors[idx];
		}
		else
		{
			return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
		}
	}
}