/**
 * Copyright shaggy ( http://wonderfl.net/user/shaggy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kiIE
 */

// forked from umhr's SlideShow(Ken Burns Effect)
/*
 * Picasa Web Albums Data API
 * http://code.google.com/intl/ja/apis/picasaweb/docs/2.0/reference.html
*/
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.DropShadowFilter;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.Security;
	import flash.text.TextField;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	
	[SWF(backgroundColor="0x000000")]
	public class Main extends Sprite {
		private var _data_array:Array;
		private var _loadCount:int;
		
		public function Main() {
			//FULL SCREENに対応させるため、計算しやすいように左上基準、noScaleにする。
			stage.align = "TL";
			stage.scaleMode = "noScale";
			
			//URLLoaderを作る
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener(Event.COMPLETE, onCompleteXML);
			//検索ワードを数種類の中からランダムに出るようにする。
			var keywords_array:Array = ["waterdrop", "red", "moon", "fireworks", "eclipse"];
			var keyword:String = keywords_array[Math.floor(Math.random() * keywords_array.length)];
			
			//検索の開始位置を指定する。
			var startIndex:int = Math.ceil(Math.random() * 10);
			//検索
			var xmlURL:String = "http://photos.googleapis.com/data/feed/base/all?alt=rss&kind=photo&q="+keyword+"&imglic=commercial&max-results=6&imgmax=512&start-index=" + startIndex;
			//クロスドメインポリシーファイルの位置を指定
			Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");
			myURLLoader.load(new URLRequest(xmlURL));
		}
		
		private function onCompleteXML(e:Event):void {
			//取得したデータをXML型に
			var myXML:XML = new XML(e.currentTarget.data);
			//namespaceを設定
			default xml namespace = new Namespace("http://search.yahoo.com/mrss/");
			_data_array = [];		//*1
			//XMLを解析
			for (var i:int = 0; i < 6; i++) {
				//画像のロード
				var myLoader:Loader = new Loader();
				var myURLRequest:URLRequest = new URLRequest(myXML.channel.item[i].group.content.@url);
				//クロスドメインポリシーファイルをドキュメントルートから取得
				var myLoaderContext:LoaderContext = new LoaderContext(true);
				myLoader.load(myURLRequest, myLoaderContext);
				myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteImg);
				
				//Objectをつくり、必要な値を入れる
				var data:Object = new Object();		//*2
				data["link"] = myXML.channel.item[i].link;
				data["credit"] = myXML.channel.item[i].group.credit;
				data["loader"] = myLoader;
				
				//arrayに入れて、後から使いやすいように
				_data_array[i] = data;		//*3
			}
			trace(_data_array[0].link);
		}
		
		private function onCompleteImg(e:Event):void {
			//画像は6枚読み込むので、6回onCompleteImgが呼び出されるが、
			//5回目までは処理が先に進まないように
			_loadCount ++;
			if (_loadCount < 6) {
				return;
			};
			
			//読み込んだ画像をdata_arrayにいれる。
			for (var i:int = 0; i < 6; i++) {
				//読み込んだ画像の幅と高さを取得
				var imgWidth:int = _data_array[i].loader.content.width;
				var imgHeight:int = _data_array[i].loader.content.height;
				//読み込んだ画像が拡大しても荒れない処理のために一時bitmapdataにする
				var myBitmapData:BitmapData = new BitmapData(imgWidth, imgHeight);
				myBitmapData.draw(_data_array[i].loader.content);
				//拡大しても荒れないようにsmoothをtrueに
				var smoothBitmap:Bitmap = new Bitmap(myBitmapData, "auto", true);
				_data_array[i]["bitmap"] = smoothBitmap;
			}
			
			//5秒おきにzoomTweenを実行する処理を設定。
			//{num:0}を設定することによって、何回目の呼び出しかを取得できるようにする。
			var t:ITween = BetweenAS3.delay(BetweenAS3.func(zoomTween, [ { num:0 } ]), 5);
			//無限ループに設定
			t.stopOnComplete = false;
			//4秒目から実行
			t.gotoAndPlay(4);
		}
		
		private function zoomTween(count:Object):void {
			//zoom処理
			
			//ターゲットを設定。
			var target:Object = _data_array[count.num % 5];
			//カウントをひとつ繰り上げる
			count.num++;
			//拡大率や中心位置を設定
			//画像を拡大／縮小した後である場合を考慮し、１倍にする。
			target.bitmap.scaleX = target.bitmap.scaleY = 1;
			
			//ステージサイズ一杯に見えるような拡大率を求める。
			var scaleFrom:Number = Math.max(stage.stageWidth / target.bitmap.width , stage.stageHeight / target.bitmap.height);
			var scaleTo:Number = 1.1 * scaleFrom;
			var xFrom:Number = 0;
			var xTo:Number = 0;
			var yFrom:Number = 0;
			var yTo:Number = 0;
			
			//見ていて飽きないように三分の一の確率で
			//ズームの中心位置を、右端、中央、左端のどれかに設定
			if (Math.random() < 0.33) {
				xFrom = stage.stageWidth - scaleFrom * target.bitmap.width;
				xTo = stage.stageWidth - scaleTo * target.bitmap.width;
			}else if (Math.random() < 0.5) {
				xFrom = (stage.stageWidth - scaleFrom * target.bitmap.width) * 0.5;
				xTo = (stage.stageWidth - scaleTo * target.bitmap.width) * 0.5;
			}
			//ズームの中心位置を、下端、中央、上端のどれかに設定
			if (Math.random() < 0.33) {
				yFrom = stage.stageHeight - scaleFrom * target.bitmap.height;
				yTo = stage.stageHeight - scaleTo * target.bitmap.height;
			}else if (Math.random() < 0.5) {
				yFrom = (stage.stageHeight - scaleFrom * target.bitmap.height) * 0.5;
				yTo = (stage.stageHeight - scaleTo * target.bitmap.height) * 0.5;
			}
			//半分の確率で拡大／縮小の動きになるように
			if (Math.random() < 0.5) {
				var temp:Number = scaleFrom;
				scaleFrom = scaleTo;
				scaleTo = temp;
				temp = xFrom;
				xFrom = xTo;
				xTo = temp;
				temp = yFrom;
				yFrom = yTo;
				yTo = temp;
			}
			
			//クレジット＆リンクのためのテキストフィールドを作る。
			var textField:TextField = new TextField();
			textField.htmlText = "<a href='" + target.link + "'>Photo by " + target.credit + "</a>";
			textField.autoSize = "left";
			textField.textColor = 0xFFFFFF;
			//ドロップシャドウをかける
			var dsf:DropShadowFilter = new DropShadowFilter();
			textField.filters = [dsf];
			
			//addChildして、フェードイン＆拡大を６秒行った後、remove
			var t:ITween = BetweenAS3.serial(
				BetweenAS3.parallel(
				//addChild
					BetweenAS3.addChild(target.bitmap, this),
					BetweenAS3.addChild(textField, this)
				),
				BetweenAS3.parallel(
				//フェードイン＆拡大
					BetweenAS3.tween(target.bitmap, { alpha:1 }, { alpha:0 }, 1),
					BetweenAS3.tween(target.bitmap, { x: xTo, y:yTo, scaleX:scaleTo, scaleY:scaleTo }, { x: xFrom, y: yFrom, scaleX:scaleFrom, scaleY:scaleFrom }, 6),
					BetweenAS3.tween(textField, { alpha:1 }, { alpha:0 }, 1)
				),
				//一通り終わったら削除
				BetweenAS3.parallel(
					BetweenAS3.removeFromParent(target.bitmap),
					BetweenAS3.removeFromParent(textField)
				)
			);
			//実行
			t.play();
		}
	}
}
