/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/khdl
 */

// forked from knd's forked from: flash on 2010-3-1
// forked from uraac's flash on 2010-3-1
package
{
	import flash.display.Sprite;
	import flash.text.TextField;

	[SWF( backgroundColor="#000000" )]
	public class PascalsTriangle extends Sprite{

		private const EXPONENT:Number = 250;
		private const MODULUS:Number = 7;
		private var colorMap:Array;
		private var steps:Array;
		private var fractMemory:Object;

		public function PascalsTriangle()
		{
			fractMemory = {};
			prepareColorMap();
			prepareSteps();
			drawShape();
		}

		private function prepareColorMap():void
		{
			colorMap = [];
			var colorChunk:int = 0xeeeeee / MODULUS;
			for (var cmapindex:int = 0; cmapindex < MODULUS; cmapindex++)
			{
				colorMap[cmapindex] = colorChunk * (cmapindex+1);
			}
		}

		private function prepareSteps():void
		{
			steps = new Array(EXPONENT);

			steps[0] = [1];
			steps[1] = [1, 1];
			for(var stepc:int = 2; stepc < EXPONENT; stepc++)
			{
				steps[stepc] = makeStep(stepc, steps[stepc - 1]);
			}
		}

		private function makeStep(stepc:int, prev:Array):Array
		{
			var result:Array = new Array(stepc + 1);
			result[0] = 1;
			result[stepc] = 1; 
			
			// C(n,k)=C(n-1,k-1)+C(n-1,k)
			for (var stepe:int = 1; stepe < stepc; stepe++)
			{
				result[stepe] = (prev[stepe-1] + prev[stepe]) % MODULUS;
			} 
			return result;
		}

		private function drawShape():void
		{

			//var t:TextField = new TextField();
			//t.textColor = 0xFFFFFF;
			//t.x = 100;
			
			var px:Number = 228;
			var py:Number = 0;
			var radius:Number = 2;
			for (var stepc:int = 0; stepc < EXPONENT; stepc++)
			{
				px -= radius;
				var lpx:Number = px;
				var step:Array = steps[stepc] as Array;
				for (var r:int = 0; r <= stepc; r++)
				{
					this.graphics.beginFill(uint(colorMap[step[r]]));
					this.graphics.drawCircle(lpx,py,radius);
					this.graphics.endFill();

					lpx += radius * 2;

					//t.appendText(keisu.toString());
					//t.appendText(",");
				}
				py += radius*Math.sqrt(3);

				//t.appendText("\n");
			}
			//addChild(t);
		}

	}
}
