/**
 * Copyright xzardaz ( http://wonderfl.net/user/xzardaz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/khRV
 */

/*

Basic View example in Away3d
 
Demonstrates:
 
How to create a 3D environment for your objects
How to add a new textured object to your world
How to rotate an object in your world

Code by Rob Bateman
rob@infiniteturtles.co.uk
http://www.infiniteturtles.co.uk

This code is distributed under the MIT License

Copyright (c)  

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the “Software”), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/
 //ok
package
{
    

    import away3d.containers.*;
    import away3d.entities.*;
    import away3d.materials.*;
    import away3d.primitives.*;
    import away3d.utils.*;
    
        
    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Vector3D;

    [SWF(backgroundColor="#000000", frameRate="60")]
    
    public class Basic_View extends Sprite
    {
        //plane texture
        //[Embed(source="../embeds/floor_diffuse.jpg")]
        public static var FloorDiffuse:Class;
        
        //engine variables
        private var _view:View3D;
        
        //scene objects
        private var _plane:Mesh;
        
        /**
         * Constructor
         */
        public function Basic_View()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            //setup the view
            _view = new View3D();
            addChild(_view);
            
            //setup the camera
            _view.camera.z = -600;
            _view.camera.y = 500;
            _view.camera.lookAt(new Vector3D());
            
            //setup the scene
            _plane = new Mesh(new PlaneGeometry(700, 700));
            _view.scene.addChild(_plane);
            
            //setup the render loop
            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
            stage.addEventListener(Event.RESIZE, onResize);
            onResize();
        }
        
        /**
         * render loop
         */
        private function _onEnterFrame(e:Event):void
        {
            _plane.rotationY += 1;
            
            _view.render();
        }
        
        /**
         * stage listener for resize events
         */
        private function onResize(event:Event = null):void
        {
            _view.width = stage.stageWidth;
            _view.height = stage.stageHeight;
        }
    }
}
