/**
 * Copyright kenta ( http://wonderfl.net/user/kenta )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/khF4
 */

package {
    import flash.display.MovieClip;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.geom.*;

    public class ZAxisExample1 extends MovieClip {
        private var ellipse1Back:int = 1;
        private var ellipse2Back:int = 1;
        private var depth:int = 1000;
        
        public function ZAxisExample1():void {
            
            var ellipse1 = drawEllipse((this.stage.stageWidth / 2) - 100, 
                                      (this.stage.stageHeight / 2), 100, 80, 10);
            var ellipse2 = drawEllipse((this.stage.stageWidth / 2) + 100, 
                                      (this.stage.stageHeight / 2), 100, 80, 300);

            this.addChild(ellipse1);
            this.addChild(ellipse2);
            
            ellipse1.addEventListener(Event.ENTER_FRAME, ellipse1FrameHandler);
            ellipse2.addEventListener(Event.ENTER_FRAME, ellipse2FrameHandler);
        }

        private function drawEllipse(x:Number, y:Number, w:Number, h:Number, z:Number):Shape {
            var s:Shape = new Shape();                            
            s.z = z;
            s.graphics.beginFill(0xFF0000);
            s.graphics.lineStyle(2);
            s.graphics.drawEllipse(x, y, w, h);
            s.graphics.endFill();
            return s;
        }

        private function ellipse1FrameHandler(e:Event):void {
            ellipse1Back = setDepth(e, ellipse1Back);
            e.currentTarget.z += ellipse1Back * 10;
        }

        private function ellipse2FrameHandler(e:Event):void {
            ellipse2Back = setDepth(e, ellipse2Back);
            e.currentTarget.z += ellipse2Back * 20;
        }

        private function setDepth(e:Event, d:int):int {
            if(e.currentTarget.z > depth) {
                e.currentTarget.z = depth; 
                d = -1;
            }else if (e.currentTarget.z <  0) {
                e.currentTarget.z = 0;
                d = 1;
            }
            return d;
        }
    }
}